/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.metadata;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequestType;
import com.amazonaws.athena.connector.lambda.metadata.MetadataResponse;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class GetTableLayoutResponse
extends MetadataResponse {
    private final TableName tableName;
    private final Block partitions;

    @JsonCreator
    public GetTableLayoutResponse(@JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="tableName") TableName tableName, @JsonProperty(value="partitions") Block partitions) {
        super(MetadataRequestType.GET_TABLE_LAYOUT, catalogName);
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(partitions, "partitions is null");
        this.tableName = tableName;
        this.partitions = partitions;
    }

    @JsonProperty
    public TableName getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public Block getPartitions() {
        return this.partitions;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("requestType", (Object)this.getRequestType()).add("catalogName", (Object)this.getCatalogName()).toString();
    }

    @Override
    public void close() throws Exception {
        this.partitions.close();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTableLayoutResponse that = (GetTableLayoutResponse)o;
        return com.google.common.base.Objects.equal((Object)this.tableName, (Object)that.tableName) && com.google.common.base.Objects.equal((Object)this.partitions, (Object)that.partitions) && com.google.common.base.Objects.equal((Object)((Object)this.getRequestType()), (Object)((Object)that.getRequestType())) && com.google.common.base.Objects.equal((Object)this.getCatalogName(), (Object)that.getCatalogName());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.tableName, this.partitions, this.getRequestType(), this.getCatalogName()});
    }
}

