/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.security;

import com.amazonaws.athena.connector.lambda.security.EncryptionKey;
import com.amazonaws.athena.connector.lambda.security.EncryptionKeyFactory;
import java.security.SecureRandom;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class LocalKeyFactory
implements EncryptionKeyFactory {
    private static ExecutorService es = Executors.newSingleThreadExecutor();

    @Override
    public EncryptionKey create() {
        Future<EncryptionKey> future = es.submit(() -> {
            SecureRandom random = SecureRandom.getInstanceStrong();
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(128, random);
            SecretKey key = keyGen.generateKey();
            byte[] nonce = new byte[12];
            random.nextBytes(nonce);
            return new EncryptionKey(key.getEncoded(), nonce);
        });
        try {
            EncryptionKey encryptionKey = future.get(1000L, TimeUnit.MILLISECONDS);
            return encryptionKey;
        }
        catch (TimeoutException ex) {
            throw new RuntimeException("Attempt to generate key took too long. There may be an issue where your platform does not have enough entropy in /dev/random. Consider using KmsKeyFactory instead", ex);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            future.cancel(true);
        }
    }
}

