/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.amazonaws.athena.connector.lambda.serde.BaseDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.Objects;

public abstract class TypedDeserializer<T>
extends BaseDeserializer<T> {
    private Class<? extends T> subType;

    protected TypedDeserializer(Class<T> superType, Class<? extends T> subType) {
        super(superType);
        this.subType = Objects.requireNonNull(subType, "subType is null");
    }

    public Class<? extends T> getSubType() {
        return this.subType;
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.doDeserialize(jp, ctxt);
    }

    @Override
    public T doDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
        this.getType(jparser);
        return this.doTypedDeserialize(jparser, ctxt);
    }

    protected abstract T doTypedDeserialize(JsonParser var1, DeserializationContext var2) throws IOException;
}

