/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.domain.predicate.AllOrNoneValueSet;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueSet;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.amazonaws.athena.connector.lambda.serde.v2.ArrowTypeSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.ArrowType;

public final class AllOrNoneValueSetSerDe {
    private static final String TYPE_FIELD = "type";
    private static final String ALL_FIELD = "all";
    private static final String NULL_ALLOWED_FIELD = "nullAllowed";

    private AllOrNoneValueSetSerDe() {
    }

    public static final class Deserializer
    extends TypedDeserializer<ValueSet> {
        private final ArrowTypeSerDe.Deserializer arrowTypeDeserializer;

        public Deserializer(ArrowTypeSerDe.Deserializer arrowTypeDeserializer) {
            super(ValueSet.class, AllOrNoneValueSet.class);
            this.arrowTypeDeserializer = Objects.requireNonNull(arrowTypeDeserializer, "arrowTypeSerDe is null");
        }

        @Override
        protected AllOrNoneValueSet doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.assertFieldName(jparser, AllOrNoneValueSetSerDe.TYPE_FIELD);
            ArrowType type = (ArrowType)this.arrowTypeDeserializer.deserialize(jparser, ctxt);
            boolean all = this.getNextBoolField(jparser, AllOrNoneValueSetSerDe.ALL_FIELD);
            boolean nullAllowed = this.getNextBoolField(jparser, AllOrNoneValueSetSerDe.NULL_ALLOWED_FIELD);
            return new AllOrNoneValueSet(type, all, nullAllowed);
        }
    }

    public static final class Serializer
    extends TypedSerializer<ValueSet> {
        private final ArrowTypeSerDe.Serializer arrowTypeSerializer;

        public Serializer(ArrowTypeSerDe.Serializer arrowTypeSerialzer) {
            super(ValueSet.class, AllOrNoneValueSet.class);
            this.arrowTypeSerializer = Objects.requireNonNull(arrowTypeSerialzer, "arrowTypeSerialzer is null");
        }

        @Override
        protected void doTypedSerialize(ValueSet valueSet, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            AllOrNoneValueSet allOrNoneValueSet = (AllOrNoneValueSet)valueSet;
            jgen.writeFieldName(AllOrNoneValueSetSerDe.TYPE_FIELD);
            this.arrowTypeSerializer.serialize(allOrNoneValueSet.getType(), jgen, provider);
            jgen.writeBooleanField(AllOrNoneValueSetSerDe.ALL_FIELD, allOrNoneValueSet.isAll());
            jgen.writeBooleanField(AllOrNoneValueSetSerDe.NULL_ALLOWED_FIELD, allOrNoneValueSet.isNullAllowed());
        }
    }
}

