/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.metadata.ListTablesRequest;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequest;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.amazonaws.athena.connector.lambda.serde.FederatedIdentitySerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.MetadataRequestDeserializer;
import com.amazonaws.athena.connector.lambda.serde.v2.MetadataRequestSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;

public final class ListTablesRequestSerDe {
    private static final String IDENTITY_FIELD = "identity";
    private static final String QUERY_ID_FIELD = "queryId";
    private static final String CATALOG_NAME_FIELD = "catalogName";
    private static final String SCHEMA_NAME_FIELD = "schemaName";
    private static final String PAGE_SIZE_FIELD = "pageSize";
    private static final String NEXT_TOKEN_FIELD = "nextToken";

    private ListTablesRequestSerDe() {
    }

    public static final class Deserializer
    extends MetadataRequestDeserializer {
        private final FederatedIdentitySerDe.Deserializer identityDeserializer;

        public Deserializer(FederatedIdentitySerDe.Deserializer identityDeserializer) {
            super(ListTablesRequest.class, identityDeserializer);
            this.identityDeserializer = Objects.requireNonNull(identityDeserializer, "identityDeserializer is null");
        }

        @Override
        protected MetadataRequest doRequestDeserialize(JsonParser jparser, DeserializationContext ctxt, FederatedIdentity identity, String queryId, String catalogName) throws IOException {
            String schemaName = this.getNextStringField(jparser, ListTablesRequestSerDe.SCHEMA_NAME_FIELD);
            String nextToken = null;
            int pageSize = -1;
            if (!JsonToken.END_OBJECT.equals((Object)jparser.nextToken()) && jparser.getCurrentName().equals(ListTablesRequestSerDe.NEXT_TOKEN_FIELD)) {
                jparser.nextToken();
                nextToken = jparser.getValueAsString();
                pageSize = this.getNextIntField(jparser, ListTablesRequestSerDe.PAGE_SIZE_FIELD);
            }
            return new ListTablesRequest(identity, queryId, catalogName, schemaName, nextToken, pageSize);
        }
    }

    public static final class Serializer
    extends MetadataRequestSerializer {
        private final FederatedIdentitySerDe.Serializer identitySerializer;

        public Serializer(FederatedIdentitySerDe.Serializer identitySerializer) {
            super(ListTablesRequest.class, identitySerializer);
            this.identitySerializer = Objects.requireNonNull(identitySerializer, "identitySerializer is null");
        }

        @Override
        protected void doRequestSerialize(FederationRequest federationRequest, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            ListTablesRequest listTablesRequest = (ListTablesRequest)federationRequest;
            jgen.writeStringField(ListTablesRequestSerDe.SCHEMA_NAME_FIELD, listTablesRequest.getSchemaName());
            jgen.writeStringField(ListTablesRequestSerDe.NEXT_TOKEN_FIELD, listTablesRequest.getNextToken());
            jgen.writeNumberField(ListTablesRequestSerDe.PAGE_SIZE_FIELD, listTablesRequest.getPageSize());
        }
    }
}

