/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.amazonaws.athena.connector.lambda.serde.FederatedIdentitySerDe;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import java.util.Objects;

public abstract class MetadataRequestDeserializer
extends TypedDeserializer<FederationRequest> {
    private final FederatedIdentitySerDe.Deserializer identityDeserializer;

    protected MetadataRequestDeserializer(Class<? extends FederationRequest> subType, FederatedIdentitySerDe.Deserializer identityDeserializer) {
        super(FederationRequest.class, subType);
        this.identityDeserializer = Objects.requireNonNull(identityDeserializer, "identityDeserializer is null");
    }

    @Override
    protected FederationRequest doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
        this.assertFieldName(jparser, "identity");
        FederatedIdentity identity = this.identityDeserializer.deserialize(jparser, ctxt);
        String queryId = this.getNextStringField(jparser, "queryId");
        String catalogName = this.getNextStringField(jparser, "catalogName");
        return this.doRequestDeserialize(jparser, ctxt, identity, queryId, catalogName);
    }

    protected abstract FederationRequest doRequestDeserialize(JsonParser var1, DeserializationContext var2, FederatedIdentity var3, String var4, String var5) throws IOException;
}

