/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.domain.predicate.Marker;
import com.amazonaws.athena.connector.lambda.domain.predicate.Range;
import com.amazonaws.athena.connector.lambda.serde.BaseDeserializer;
import com.amazonaws.athena.connector.lambda.serde.BaseSerializer;
import com.amazonaws.athena.connector.lambda.serde.v2.MarkerSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;

public final class RangeSerDe {
    private static final String LOW_FIELD = "low";
    private static final String HIGH_FIELD = "high";

    private RangeSerDe() {
    }

    public static final class Deserializer
    extends BaseDeserializer<Range> {
        private final MarkerSerDe.Deserializer markerDeserializer;

        public Deserializer(MarkerSerDe.Deserializer markerDeserializer) {
            super(Range.class);
            this.markerDeserializer = Objects.requireNonNull(markerDeserializer, "markerDeserializer is null");
        }

        @Override
        public Range doDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.assertFieldName(jparser, RangeSerDe.LOW_FIELD);
            Marker low = (Marker)this.markerDeserializer.deserialize(jparser, ctxt);
            this.assertFieldName(jparser, RangeSerDe.HIGH_FIELD);
            Marker high = (Marker)this.markerDeserializer.deserialize(jparser, ctxt);
            return new Range(low, high);
        }
    }

    public static final class Serializer
    extends BaseSerializer<Range> {
        private final MarkerSerDe.Serializer markerSerializer;

        public Serializer(MarkerSerDe.Serializer markerSerializer) {
            super(Range.class);
            this.markerSerializer = Objects.requireNonNull(markerSerializer, "markerSerializer is null");
        }

        @Override
        public void doSerialize(Range range, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeFieldName(RangeSerDe.LOW_FIELD);
            this.markerSerializer.serialize(range.getLow(), jgen, provider);
            jgen.writeFieldName(RangeSerDe.HIGH_FIELD);
            this.markerSerializer.serialize(range.getHigh(), jgen, provider);
        }
    }
}

