/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.amazonaws.athena.connector.lambda.serde.VersionedSerDe;
import com.amazonaws.athena.connector.lambda.udf.UserDefinedFunctionResponse;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;

public final class UserDefinedFunctionResponseSerDe {
    private static final String RECORDS_FIELD = "records";
    private static final String METHOD_NAME_FIELD = "methodName";

    private UserDefinedFunctionResponseSerDe() {
    }

    public static final class Deserializer
    extends TypedDeserializer<FederationResponse> {
        private final VersionedSerDe.Deserializer<Block> blockDeserializer;

        public Deserializer(VersionedSerDe.Deserializer<Block> blockDeserializer) {
            super(FederationResponse.class, UserDefinedFunctionResponse.class);
            this.blockDeserializer = Objects.requireNonNull(blockDeserializer, "blockDeserializer is null");
        }

        @Override
        protected FederationResponse doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.assertFieldName(jparser, UserDefinedFunctionResponseSerDe.RECORDS_FIELD);
            Block records = this.blockDeserializer.deserialize(jparser, ctxt);
            String methodName = this.getNextStringField(jparser, UserDefinedFunctionResponseSerDe.METHOD_NAME_FIELD);
            return new UserDefinedFunctionResponse(records, methodName);
        }
    }

    public static final class Serializer
    extends TypedSerializer<FederationResponse> {
        private final VersionedSerDe.Serializer<Block> blockSerializer;

        public Serializer(VersionedSerDe.Serializer<Block> blockSerializer) {
            super(FederationResponse.class, UserDefinedFunctionResponse.class);
            this.blockSerializer = Objects.requireNonNull(blockSerializer, "blockSerializer is null");
        }

        @Override
        protected void doTypedSerialize(FederationResponse federationResponse, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            UserDefinedFunctionResponse userDefinedFunctionResponse = (UserDefinedFunctionResponse)federationResponse;
            jgen.writeFieldName(UserDefinedFunctionResponseSerDe.RECORDS_FIELD);
            this.blockSerializer.serialize(userDefinedFunctionResponse.getRecords(), jgen, provider);
            jgen.writeStringField(UserDefinedFunctionResponseSerDe.METHOD_NAME_FIELD, userDefinedFunctionResponse.getMethodName());
        }
    }
}

