/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v4;

import com.amazonaws.athena.connector.lambda.domain.predicate.expression.FederationExpression;
import com.amazonaws.athena.connector.lambda.domain.predicate.expression.FunctionCallExpression;
import com.amazonaws.athena.connector.lambda.domain.predicate.functions.FunctionName;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.amazonaws.athena.connector.lambda.serde.VersionedSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.ArrowTypeSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.ArrowType;

public final class FunctionCallExpressionSerDeV4 {
    private static final String FUNCTION_NAME_FIELD = "functionName";
    private static final String TYPE_FIELD = "type";
    private static final String ARGUMENTS_FIELD = "arguments";

    private FunctionCallExpressionSerDeV4() {
    }

    public static final class Deserializer
    extends TypedDeserializer<FederationExpression>
    implements VersionedSerDe.Deserializer<FederationExpression> {
        private final VersionedSerDe.Deserializer<FunctionName> functionNameDeserializer;
        private final ArrowTypeSerDe.Deserializer arrowTypeDeserializer;
        private VersionedSerDe.Deserializer<FederationExpression> federationExpressionDeserializer;

        public Deserializer(VersionedSerDe.Deserializer<FunctionName> functionNameDeserializer, ArrowTypeSerDe.Deserializer arrowTypeDeserializer) {
            super(FederationExpression.class, FunctionCallExpression.class);
            this.functionNameDeserializer = Objects.requireNonNull(functionNameDeserializer, "functionNameSerializer is null");
            this.arrowTypeDeserializer = Objects.requireNonNull(arrowTypeDeserializer, "arrowTypeSerializer is null");
        }

        public void setFederationExpressionSerializer(VersionedSerDe.Deserializer<FederationExpression> federationExpressionDeserializer) {
            this.federationExpressionDeserializer = federationExpressionDeserializer;
        }

        @Override
        protected FunctionCallExpression doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.assertFieldName(jparser, FunctionCallExpressionSerDeV4.TYPE_FIELD);
            ArrowType type = (ArrowType)this.arrowTypeDeserializer.deserialize(jparser, ctxt);
            this.assertFieldName(jparser, FunctionCallExpressionSerDeV4.FUNCTION_NAME_FIELD);
            FunctionName functionName = this.functionNameDeserializer.deserialize(jparser, ctxt);
            this.assertFieldName(jparser, FunctionCallExpressionSerDeV4.ARGUMENTS_FIELD);
            this.validateArrayStart(jparser);
            ImmutableList.Builder federationExpressionList = ImmutableList.builder();
            while (jparser.nextToken() != JsonToken.END_ARRAY) {
                this.validateObjectStart(jparser.getCurrentToken());
                federationExpressionList.add((Object)this.federationExpressionDeserializer.doDeserialize(jparser, ctxt));
                this.validateObjectEnd(jparser);
            }
            return new FunctionCallExpression(type, functionName, (List<FederationExpression>)federationExpressionList.build());
        }
    }

    public static final class Serializer
    extends TypedSerializer<FederationExpression>
    implements VersionedSerDe.Serializer<FederationExpression> {
        private final VersionedSerDe.Serializer<FunctionName> functionNameSerializer;
        private final ArrowTypeSerDe.Serializer arrowTypeSerializer;
        private VersionedSerDe.Serializer<FederationExpression> federationExpressionSerializer;

        public Serializer(VersionedSerDe.Serializer<FunctionName> functionNameSerializer, ArrowTypeSerDe.Serializer arrowTypeSerializer) {
            super(FederationExpression.class, FunctionCallExpression.class);
            this.functionNameSerializer = Objects.requireNonNull(functionNameSerializer, "functionNameSerializer is null");
            this.arrowTypeSerializer = Objects.requireNonNull(arrowTypeSerializer, "arrowTypeSerializer is null");
        }

        public void setFederationExpressionSerializer(VersionedSerDe.Serializer<FederationExpression> federationExpressionSerializer) {
            this.federationExpressionSerializer = federationExpressionSerializer;
        }

        @Override
        protected void doTypedSerialize(FederationExpression federationExpression, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            FunctionCallExpression functionCallExpression = (FunctionCallExpression)federationExpression;
            jgen.writeFieldName(FunctionCallExpressionSerDeV4.TYPE_FIELD);
            this.arrowTypeSerializer.serialize(functionCallExpression.getType(), jgen, provider);
            jgen.writeFieldName(FunctionCallExpressionSerDeV4.FUNCTION_NAME_FIELD);
            this.functionNameSerializer.serialize(functionCallExpression.getFunctionName(), jgen, provider);
            jgen.writeArrayFieldStart(FunctionCallExpressionSerDeV4.ARGUMENTS_FIELD);
            for (FederationExpression expression : functionCallExpression.getArguments()) {
                this.federationExpressionSerializer.serialize(expression, jgen, provider);
            }
            jgen.writeEndArray();
        }
    }
}

