/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v4;

import com.amazonaws.athena.connector.lambda.metadata.GetDataSourceCapabilitiesResponse;
import com.amazonaws.athena.connector.lambda.metadata.optimizations.OptimizationSubType;
import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.amazonaws.athena.connector.lambda.serde.VersionedSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class GetDataSourceCapabilitiesResponseSerDeV4 {
    private static final String CATALOG_NAME_FIELD = "catalogName";
    private static final String CAPABILITIES_NAME_FIELD = "capabilities";

    private GetDataSourceCapabilitiesResponseSerDeV4() {
    }

    public static final class Deserializer
    extends TypedDeserializer<FederationResponse>
    implements VersionedSerDe.Deserializer<FederationResponse> {
        private final VersionedSerDe.Deserializer<OptimizationSubType> optimizationSubTypeDeserializer;

        public Deserializer(VersionedSerDe.Deserializer<OptimizationSubType> optimizationSubTypeDeserializer) {
            super(FederationResponse.class, GetDataSourceCapabilitiesResponse.class);
            this.optimizationSubTypeDeserializer = optimizationSubTypeDeserializer;
        }

        @Override
        protected FederationResponse doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            String catalogName = this.getNextStringField(jparser, GetDataSourceCapabilitiesResponseSerDeV4.CATALOG_NAME_FIELD);
            this.assertFieldName(jparser, GetDataSourceCapabilitiesResponseSerDeV4.CAPABILITIES_NAME_FIELD);
            jparser.nextToken();
            ImmutableMap.Builder capabilities = ImmutableMap.builder();
            while (jparser.nextToken() != JsonToken.END_OBJECT) {
                String field = jparser.getCurrentName();
                jparser.nextToken();
                ImmutableList.Builder optimizationSubType = ImmutableList.builder();
                while (jparser.nextToken() != JsonToken.END_ARRAY) {
                    this.validateObjectStart(jparser.getCurrentToken());
                    optimizationSubType.add((Object)this.optimizationSubTypeDeserializer.doDeserialize(jparser, ctxt));
                    this.validateObjectEnd(jparser);
                }
                capabilities.put((Object)field, (Object)optimizationSubType.build());
            }
            return new GetDataSourceCapabilitiesResponse(catalogName, (Map<String, List<OptimizationSubType>>)capabilities.build());
        }
    }

    public static final class Serializer
    extends TypedSerializer<FederationResponse>
    implements VersionedSerDe.Serializer<FederationResponse> {
        private final VersionedSerDe.Serializer<OptimizationSubType> optimizationSubTypeSerializer;

        public Serializer(VersionedSerDe.Serializer<OptimizationSubType> optimizationSubTypeSerializer) {
            super(FederationResponse.class, GetDataSourceCapabilitiesResponse.class);
            this.optimizationSubTypeSerializer = optimizationSubTypeSerializer;
        }

        @Override
        protected void doTypedSerialize(FederationResponse federationResponse, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            GetDataSourceCapabilitiesResponse getDataSourceCapabilitiesResponse = (GetDataSourceCapabilitiesResponse)federationResponse;
            jgen.writeStringField(GetDataSourceCapabilitiesResponseSerDeV4.CATALOG_NAME_FIELD, getDataSourceCapabilitiesResponse.getCatalogName());
            jgen.writeObjectFieldStart(GetDataSourceCapabilitiesResponseSerDeV4.CAPABILITIES_NAME_FIELD);
            for (Map.Entry<String, List<OptimizationSubType>> entry : getDataSourceCapabilitiesResponse.getCapabilities().entrySet()) {
                jgen.writeArrayFieldStart(entry.getKey());
                for (OptimizationSubType optimizationSubType : entry.getValue()) {
                    this.optimizationSubTypeSerializer.serialize(optimizationSubType, jgen, provider);
                }
                jgen.writeEndArray();
            }
            jgen.writeEndObject();
        }
    }
}

