/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v4;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.serde.FederatedIdentitySerDe;
import com.amazonaws.athena.connector.lambda.serde.PingRequestSerDe;
import com.amazonaws.athena.connector.lambda.serde.PingResponseSerDe;
import com.amazonaws.athena.connector.lambda.serde.VersionedSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.AllOrNoneValueSetSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.ArrowTypeSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.EncryptionKeySerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.EquatableValueSetSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.GetSplitsRequestSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.GetSplitsResponseSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.GetTableLayoutRequestSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.GetTableLayoutResponseSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.GetTableRequestSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.GetTableResponseSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.LambdaFunctionExceptionSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.ListSchemasRequestSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.ListSchemasResponseSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.ListTablesRequestSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.ListTablesResponseSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.MarkerSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.RangeSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.ReadRecordsRequestSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.ReadRecordsResponseSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.RemoteReadRecordsResponseSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.S3SpillLocationSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.SortedRangeSetSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.SpillLocationSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.SplitSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.TableNameSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.UserDefinedFunctionRequestSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.UserDefinedFunctionResponseSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.ValueSetSerDe;
import com.amazonaws.athena.connector.lambda.serde.v4.BlockSerDeV4;
import com.amazonaws.athena.connector.lambda.serde.v4.ConstantExpressionSerDeV4;
import com.amazonaws.athena.connector.lambda.serde.v4.ConstraintsSerDeV4;
import com.amazonaws.athena.connector.lambda.serde.v4.FederationExpressionSerDeV4;
import com.amazonaws.athena.connector.lambda.serde.v4.FederationRequestSerDeV4;
import com.amazonaws.athena.connector.lambda.serde.v4.FederationResponseSerDeV4;
import com.amazonaws.athena.connector.lambda.serde.v4.FunctionCallExpressionSerDeV4;
import com.amazonaws.athena.connector.lambda.serde.v4.FunctionNameSerDeV4;
import com.amazonaws.athena.connector.lambda.serde.v4.GetDataSourceCapabilitiesRequestSerDeV4;
import com.amazonaws.athena.connector.lambda.serde.v4.GetDataSourceCapabilitiesResponseSerDeV4;
import com.amazonaws.athena.connector.lambda.serde.v4.OptimizationSubTypeSerDeV4;
import com.amazonaws.athena.connector.lambda.serde.v4.OrderByFieldSerDeV4;
import com.amazonaws.athena.connector.lambda.serde.v4.SchemaSerDeV4;
import com.amazonaws.athena.connector.lambda.serde.v4.VariableExpressionSerDeV4;
import com.amazonaws.services.lambda.invoke.LambdaFunctionException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.types.pojo.Schema;

public class ObjectMapperFactoryV4 {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final String LAMDA_EXCEPTION_CLASS_NAME = LambdaFunctionException.class.getName();
    private static final SerializerFactory SERIALIZER_FACTORY;

    private ObjectMapperFactoryV4() {
    }

    public static ObjectMapper create(BlockAllocator allocator) {
        return new StrictObjectMapper(allocator);
    }

    private static FederationRequestSerDeV4.Serializer createRequestSerializer() {
        FederatedIdentitySerDe.Serializer identity = new FederatedIdentitySerDe.Serializer();
        TableNameSerDe.Serializer tableName = new TableNameSerDe.Serializer();
        SchemaSerDeV4.Serializer schema = new SchemaSerDeV4.Serializer();
        BlockSerDeV4.Serializer block = new BlockSerDeV4.Serializer(schema);
        ArrowTypeSerDe.Serializer arrowType = new ArrowTypeSerDe.Serializer();
        MarkerSerDe.Serializer marker = new MarkerSerDe.Serializer(block);
        RangeSerDe.Serializer range = new RangeSerDe.Serializer(marker);
        EquatableValueSetSerDe.Serializer equatableValueSet = new EquatableValueSetSerDe.Serializer(block);
        SortedRangeSetSerDe.Serializer sortedRangeSet = new SortedRangeSetSerDe.Serializer(arrowType, range);
        AllOrNoneValueSetSerDe.Serializer allOrNoneValueSet = new AllOrNoneValueSetSerDe.Serializer(arrowType);
        ValueSetSerDe.Serializer valueSet = new ValueSetSerDe.Serializer(equatableValueSet, sortedRangeSet, allOrNoneValueSet);
        FunctionNameSerDeV4.Serializer functionName = new FunctionNameSerDeV4.Serializer();
        ConstantExpressionSerDeV4.Serializer constantExpression = new ConstantExpressionSerDeV4.Serializer(block, arrowType);
        FunctionCallExpressionSerDeV4.Serializer functionCallExpression = new FunctionCallExpressionSerDeV4.Serializer(functionName, arrowType);
        VariableExpressionSerDeV4.Serializer variableExpression = new VariableExpressionSerDeV4.Serializer(arrowType);
        FederationExpressionSerDeV4.Serializer federationExpression = new FederationExpressionSerDeV4.Serializer(constantExpression, functionCallExpression, variableExpression);
        functionCallExpression.setFederationExpressionSerializer(federationExpression);
        OrderByFieldSerDeV4.Serializer orderByField = new OrderByFieldSerDeV4.Serializer();
        ConstraintsSerDeV4.Serializer constraints = new ConstraintsSerDeV4.Serializer(valueSet, federationExpression, orderByField);
        S3SpillLocationSerDe.Serializer s3SpillLocation = new S3SpillLocationSerDe.Serializer();
        SpillLocationSerDe.Serializer spillLocation = new SpillLocationSerDe.Serializer(s3SpillLocation);
        EncryptionKeySerDe.Serializer encryptionKey = new EncryptionKeySerDe.Serializer();
        SplitSerDe.Serializer split = new SplitSerDe.Serializer(spillLocation, encryptionKey);
        PingRequestSerDe.Serializer ping = new PingRequestSerDe.Serializer(identity);
        ListSchemasRequestSerDe.Serializer listSchemas = new ListSchemasRequestSerDe.Serializer(identity);
        ListTablesRequestSerDe.Serializer listTables = new ListTablesRequestSerDe.Serializer(identity);
        GetTableRequestSerDe.Serializer getTable = new GetTableRequestSerDe.Serializer(identity, tableName);
        GetTableLayoutRequestSerDe.Serializer getTableLayout = new GetTableLayoutRequestSerDe.Serializer(identity, tableName, constraints, schema);
        GetSplitsRequestSerDe.Serializer getSplits = new GetSplitsRequestSerDe.Serializer(identity, tableName, block, constraints);
        ReadRecordsRequestSerDe.Serializer readRecords = new ReadRecordsRequestSerDe.Serializer(identity, tableName, constraints, schema, split);
        UserDefinedFunctionRequestSerDe.Serializer userDefinedFunction = new UserDefinedFunctionRequestSerDe.Serializer(identity, block, schema);
        GetDataSourceCapabilitiesRequestSerDeV4.Serializer getDataSourceCapabilities = new GetDataSourceCapabilitiesRequestSerDeV4.Serializer(identity);
        return new FederationRequestSerDeV4.Serializer(ping, listSchemas, listTables, getTable, getTableLayout, getSplits, readRecords, userDefinedFunction, getDataSourceCapabilities);
    }

    private static FederationRequestSerDeV4.Deserializer createRequestDeserializer(BlockAllocator allocator) {
        FederatedIdentitySerDe.Deserializer identity = new FederatedIdentitySerDe.Deserializer();
        TableNameSerDe.Deserializer tableName = new TableNameSerDe.Deserializer();
        SchemaSerDeV4.Deserializer schema = new SchemaSerDeV4.Deserializer();
        BlockSerDeV4.Deserializer block = new BlockSerDeV4.Deserializer(allocator, (VersionedSerDe.Deserializer<Schema>)schema);
        ArrowTypeSerDe.Deserializer arrowType = new ArrowTypeSerDe.Deserializer();
        MarkerSerDe.Deserializer marker = new MarkerSerDe.Deserializer(block);
        RangeSerDe.Deserializer range = new RangeSerDe.Deserializer(marker);
        EquatableValueSetSerDe.Deserializer equatableValueSet = new EquatableValueSetSerDe.Deserializer(block);
        SortedRangeSetSerDe.Deserializer sortedRangeSet = new SortedRangeSetSerDe.Deserializer(arrowType, range);
        AllOrNoneValueSetSerDe.Deserializer allOrNoneValueSet = new AllOrNoneValueSetSerDe.Deserializer(arrowType);
        ValueSetSerDe.Deserializer valueSet = new ValueSetSerDe.Deserializer(equatableValueSet, sortedRangeSet, allOrNoneValueSet);
        FunctionNameSerDeV4.Deserializer functionName = new FunctionNameSerDeV4.Deserializer();
        ConstantExpressionSerDeV4.Deserializer constantExpression = new ConstantExpressionSerDeV4.Deserializer(block, arrowType);
        FunctionCallExpressionSerDeV4.Deserializer functionCallExpression = new FunctionCallExpressionSerDeV4.Deserializer(functionName, arrowType);
        VariableExpressionSerDeV4.Deserializer variableExpression = new VariableExpressionSerDeV4.Deserializer(arrowType);
        FederationExpressionSerDeV4.Deserializer federationExpression = new FederationExpressionSerDeV4.Deserializer(constantExpression, functionCallExpression, variableExpression);
        functionCallExpression.setFederationExpressionSerializer(federationExpression);
        OrderByFieldSerDeV4.Deserializer orderByField = new OrderByFieldSerDeV4.Deserializer();
        ConstraintsSerDeV4.Deserializer constraints = new ConstraintsSerDeV4.Deserializer(valueSet, federationExpression, orderByField);
        S3SpillLocationSerDe.Deserializer s3SpillLocation = new S3SpillLocationSerDe.Deserializer();
        SpillLocationSerDe.Deserializer spillLocation = new SpillLocationSerDe.Deserializer(s3SpillLocation);
        EncryptionKeySerDe.Deserializer encryptionKey = new EncryptionKeySerDe.Deserializer();
        SplitSerDe.Deserializer split = new SplitSerDe.Deserializer(spillLocation, encryptionKey);
        PingRequestSerDe.Deserializer ping = new PingRequestSerDe.Deserializer(identity);
        ListSchemasRequestSerDe.Deserializer listSchemas = new ListSchemasRequestSerDe.Deserializer(identity);
        ListTablesRequestSerDe.Deserializer listTables = new ListTablesRequestSerDe.Deserializer(identity);
        GetTableRequestSerDe.Deserializer getTable = new GetTableRequestSerDe.Deserializer(identity, tableName);
        GetTableLayoutRequestSerDe.Deserializer getTableLayout = new GetTableLayoutRequestSerDe.Deserializer(identity, tableName, constraints, schema);
        GetSplitsRequestSerDe.Deserializer getSplits = new GetSplitsRequestSerDe.Deserializer(identity, tableName, block, constraints);
        ReadRecordsRequestSerDe.Deserializer readRecords = new ReadRecordsRequestSerDe.Deserializer(identity, tableName, constraints, schema, split);
        UserDefinedFunctionRequestSerDe.Deserializer userDefinedFunction = new UserDefinedFunctionRequestSerDe.Deserializer(identity, block, schema);
        GetDataSourceCapabilitiesRequestSerDeV4.Deserializer getDataSourceCapabilities = new GetDataSourceCapabilitiesRequestSerDeV4.Deserializer(identity);
        return new FederationRequestSerDeV4.Deserializer(ping, listSchemas, listTables, getTable, getTableLayout, getSplits, readRecords, userDefinedFunction, getDataSourceCapabilities);
    }

    private static FederationResponseSerDeV4.Serializer createResponseSerializer() {
        TableNameSerDe.Serializer tableName = new TableNameSerDe.Serializer();
        SchemaSerDeV4.Serializer schema = new SchemaSerDeV4.Serializer();
        BlockSerDeV4.Serializer block = new BlockSerDeV4.Serializer(schema);
        S3SpillLocationSerDe.Serializer s3SpillLocation = new S3SpillLocationSerDe.Serializer();
        SpillLocationSerDe.Serializer spillLocation = new SpillLocationSerDe.Serializer(s3SpillLocation);
        EncryptionKeySerDe.Serializer encryptionKey = new EncryptionKeySerDe.Serializer();
        SplitSerDe.Serializer split = new SplitSerDe.Serializer(spillLocation, encryptionKey);
        PingResponseSerDe.Serializer ping = new PingResponseSerDe.Serializer();
        ListSchemasResponseSerDe.Serializer listSchemas = new ListSchemasResponseSerDe.Serializer();
        ListTablesResponseSerDe.Serializer listTables = new ListTablesResponseSerDe.Serializer(tableName);
        GetTableResponseSerDe.Serializer getTable = new GetTableResponseSerDe.Serializer(tableName, schema);
        GetTableLayoutResponseSerDe.Serializer getTableLayout = new GetTableLayoutResponseSerDe.Serializer(tableName, block);
        GetSplitsResponseSerDe.Serializer getSplits = new GetSplitsResponseSerDe.Serializer(split);
        ReadRecordsResponseSerDe.Serializer readRecords = new ReadRecordsResponseSerDe.Serializer(block);
        RemoteReadRecordsResponseSerDe.Serializer remoteReadRecords = new RemoteReadRecordsResponseSerDe.Serializer(schema, spillLocation, encryptionKey);
        UserDefinedFunctionResponseSerDe.Serializer userDefinedFunction = new UserDefinedFunctionResponseSerDe.Serializer(block);
        OptimizationSubTypeSerDeV4.Serializer optimizationSubtype = new OptimizationSubTypeSerDeV4.Serializer();
        GetDataSourceCapabilitiesResponseSerDeV4.Serializer getDataSourceCapabilities = new GetDataSourceCapabilitiesResponseSerDeV4.Serializer(optimizationSubtype);
        return new FederationResponseSerDeV4.Serializer(ping, listSchemas, listTables, getTable, getTableLayout, getSplits, readRecords, remoteReadRecords, userDefinedFunction, getDataSourceCapabilities);
    }

    private static FederationResponseSerDeV4.Deserializer createResponseDeserializer(BlockAllocator allocator) {
        TableNameSerDe.Deserializer tableName = new TableNameSerDe.Deserializer();
        SchemaSerDeV4.Deserializer schema = new SchemaSerDeV4.Deserializer();
        BlockSerDeV4.Deserializer block = new BlockSerDeV4.Deserializer(allocator, (VersionedSerDe.Deserializer<Schema>)schema);
        S3SpillLocationSerDe.Deserializer s3SpillLocation = new S3SpillLocationSerDe.Deserializer();
        SpillLocationSerDe.Deserializer spillLocation = new SpillLocationSerDe.Deserializer(s3SpillLocation);
        EncryptionKeySerDe.Deserializer encryptionKey = new EncryptionKeySerDe.Deserializer();
        SplitSerDe.Deserializer split = new SplitSerDe.Deserializer(spillLocation, encryptionKey);
        PingResponseSerDe.Deserializer ping = new PingResponseSerDe.Deserializer();
        ListSchemasResponseSerDe.Deserializer listSchemas = new ListSchemasResponseSerDe.Deserializer();
        ListTablesResponseSerDe.Deserializer listTables = new ListTablesResponseSerDe.Deserializer(tableName);
        GetTableResponseSerDe.Deserializer getTable = new GetTableResponseSerDe.Deserializer(tableName, schema);
        GetTableLayoutResponseSerDe.Deserializer getTableLayout = new GetTableLayoutResponseSerDe.Deserializer(tableName, block);
        GetSplitsResponseSerDe.Deserializer getSplits = new GetSplitsResponseSerDe.Deserializer(split);
        ReadRecordsResponseSerDe.Deserializer readRecords = new ReadRecordsResponseSerDe.Deserializer(block);
        RemoteReadRecordsResponseSerDe.Deserializer remoteReadRecords = new RemoteReadRecordsResponseSerDe.Deserializer(schema, spillLocation, encryptionKey);
        UserDefinedFunctionResponseSerDe.Deserializer userDefinedFunction = new UserDefinedFunctionResponseSerDe.Deserializer(block);
        OptimizationSubTypeSerDeV4.Deserializer optimizationSubtype = new OptimizationSubTypeSerDeV4.Deserializer();
        GetDataSourceCapabilitiesResponseSerDeV4.Deserializer getDataSourceCapabilities = new GetDataSourceCapabilitiesResponseSerDeV4.Deserializer(optimizationSubtype);
        return new FederationResponseSerDeV4.Deserializer(ping, listSchemas, listTables, getTable, getTableLayout, getSplits, readRecords, remoteReadRecords, userDefinedFunction, getDataSourceCapabilities);
    }

    static {
        ImmutableList sers = ImmutableList.of((Object)ObjectMapperFactoryV4.createRequestSerializer(), (Object)ObjectMapperFactoryV4.createResponseSerializer());
        SimpleSerializers serializers = new SimpleSerializers((List)sers);
        SerializerFactoryConfig config = new SerializerFactoryConfig().withAdditionalSerializers((Serializers)serializers);
        SERIALIZER_FACTORY = new StrictSerializerFactory(config);
    }

    private static class StrictObjectMapper
    extends ObjectMapper {
        private StrictObjectMapper(BlockAllocator allocator) {
            super(JSON_FACTORY);
            this._serializerFactory = SERIALIZER_FACTORY;
            ImmutableMap desers = ImmutableMap.of(FederationRequest.class, (Object)ObjectMapperFactoryV4.createRequestDeserializer(allocator), FederationResponse.class, (Object)ObjectMapperFactoryV4.createResponseDeserializer(allocator), LambdaFunctionException.class, (Object)new LambdaFunctionExceptionSerDe.Deserializer());
            SimpleDeserializers deserializers = new SimpleDeserializers((Map)desers);
            DeserializerFactoryConfig dConfig = new DeserializerFactoryConfig().withAdditionalDeserializers((Deserializers)deserializers);
            this._deserializationContext = new DefaultDeserializationContext.Impl((DeserializerFactory)new StrictDeserializerFactory(dConfig));
            this.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        }
    }

    private static class StrictDeserializerFactory
    extends BeanDeserializerFactory {
        private StrictDeserializerFactory(DeserializerFactoryConfig config) {
            super(config);
        }

        public DeserializerFactory withConfig(DeserializerFactoryConfig config) {
            if (this._factoryConfig == config) {
                return this;
            }
            return new StrictDeserializerFactory(config);
        }

        public JsonDeserializer<Object> createBeanDeserializer(DeserializationContext ctxt, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
            for (Deserializers d : this._factoryConfig.deserializers()) {
                JsonDeserializer deser = d.findBeanDeserializer(type, ctxt.getConfig(), beanDesc);
                if (deser == null) continue;
                return deser;
            }
            throw new IllegalArgumentException("No explicitly configured deserializer for " + type);
        }
    }

    private static class StrictSerializerFactory
    extends BeanSerializerFactory {
        private StrictSerializerFactory(SerializerFactoryConfig config) {
            super(config);
        }

        public StrictSerializerFactory withConfig(SerializerFactoryConfig config) {
            if (this._factoryConfig == config) {
                return this;
            }
            return new StrictSerializerFactory(config);
        }

        public JsonSerializer<Object> createSerializer(SerializerProvider prov, JavaType origType) throws JsonMappingException {
            for (Serializers serializers : this.customSerializers()) {
                JsonSerializer ser = serializers.findSerializer(prov.getConfig(), origType, null);
                if (ser == null) continue;
                return ser;
            }
            throw new IllegalArgumentException("No explicitly configured serializer for " + origType);
        }
    }
}

