/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v4;

import com.amazonaws.athena.connector.lambda.metadata.optimizations.OptimizationSubType;
import com.amazonaws.athena.connector.lambda.serde.BaseDeserializer;
import com.amazonaws.athena.connector.lambda.serde.BaseSerializer;
import com.amazonaws.athena.connector.lambda.serde.VersionedSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;

public class OptimizationSubTypeSerDeV4 {
    private static final String SUBTYPE_FIELD = "subType";
    private static final String PROPERTIES_FIELD = "properties";

    private OptimizationSubTypeSerDeV4() {
    }

    public static final class Deserializer
    extends BaseDeserializer<OptimizationSubType>
    implements VersionedSerDe.Deserializer<OptimizationSubType> {
        public Deserializer() {
            super(OptimizationSubType.class);
        }

        @Override
        public OptimizationSubType doDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            String optimization = this.getNextStringField(jparser, OptimizationSubTypeSerDeV4.SUBTYPE_FIELD);
            List<String> properties = this.getNextStringArray(jparser, OptimizationSubTypeSerDeV4.PROPERTIES_FIELD);
            return new OptimizationSubType(optimization, properties);
        }
    }

    public static final class Serializer
    extends BaseSerializer<OptimizationSubType>
    implements VersionedSerDe.Serializer<OptimizationSubType> {
        public Serializer() {
            super(OptimizationSubType.class);
        }

        @Override
        public void doSerialize(OptimizationSubType optimizationSubType, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStringField(OptimizationSubTypeSerDeV4.SUBTYPE_FIELD, optimizationSubType.getSubType());
            this.writeStringArray(jgen, OptimizationSubTypeSerDeV4.PROPERTIES_FIELD, optimizationSubType.getProperties());
        }
    }
}

