/*-
 * #%L
 * Amazon Athena Query Federation SDK
 * %%
 * Copyright (C) 2019 - 2022 Amazon Web Services
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package com.amazonaws.athena.connector.lambda.metadata.optimizations.pushdown;

import java.util.List;

public class SubTypeProperties
    implements PushdownSubTypes
{
    private final String propertyName;
    private final List<String> propertyValues;

    public SubTypeProperties(String propertyName, List<String> propertyValues)
    {
        this.propertyName = propertyName;
        this.propertyValues = propertyValues;
    }

    @Override
    public String getSubType()
    {
        return propertyName;
    }

    @Override
    public List<String> getProperties()
    {
        return propertyValues;
    }
}
