/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.data.FieldBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;

public class SchemaBuilder {
    private final Map<String, Field> fields = new LinkedHashMap<String, Field>();
    private final ImmutableMap.Builder<String, String> metadata = ImmutableMap.builder();
    private final Map<String, FieldBuilder> nestedFieldBuilderMap = new LinkedHashMap<String, FieldBuilder>();

    public SchemaBuilder addField(Field field) {
        this.fields.put(field.getName(), field);
        return this;
    }

    public SchemaBuilder addField(String fieldName, ArrowType type) {
        this.fields.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)type), null));
        return this;
    }

    public SchemaBuilder addField(String fieldName, ArrowType type, List<Field> children) {
        this.fields.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)type), children));
        return this;
    }

    public SchemaBuilder addStructField(String fieldName) {
        this.nestedFieldBuilderMap.put(fieldName, FieldBuilder.newBuilder(fieldName, Types.MinorType.STRUCT.getType()));
        return this;
    }

    public SchemaBuilder addListField(String fieldName, ArrowType type) {
        this.fields.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.LIST.getType()), Collections.singletonList(new Field("", FieldType.nullable((ArrowType)type), null))));
        return this;
    }

    public SchemaBuilder addChildField(String parent, String child, ArrowType type) {
        this.nestedFieldBuilderMap.get(parent).addField(child, type, null);
        return this;
    }

    public SchemaBuilder addChildField(String parent, Field child) {
        this.nestedFieldBuilderMap.get(parent).addField(child);
        return this;
    }

    public SchemaBuilder addStringField(String fieldName) {
        this.fields.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.VARCHAR.getType()), null));
        return this;
    }

    public SchemaBuilder addIntField(String fieldName) {
        this.fields.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), null));
        return this;
    }

    public SchemaBuilder addTinyIntField(String fieldName) {
        this.fields.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.TINYINT.getType()), null));
        return this;
    }

    public SchemaBuilder addSmallIntField(String fieldName) {
        this.fields.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.SMALLINT.getType()), null));
        return this;
    }

    public SchemaBuilder addFloat8Field(String fieldName) {
        this.fields.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.FLOAT8.getType()), null));
        return this;
    }

    public SchemaBuilder addFloat4Field(String fieldName) {
        this.fields.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.FLOAT4.getType()), null));
        return this;
    }

    public SchemaBuilder addBigIntField(String fieldName) {
        this.fields.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.BIGINT.getType()), null));
        return this;
    }

    public SchemaBuilder addBitField(String fieldName) {
        this.fields.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.BIT.getType()), null));
        return this;
    }

    public SchemaBuilder addDecimalField(String fieldName, int precision, int scale) {
        this.fields.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)new ArrowType.Decimal(precision, scale)), null));
        return this;
    }

    public SchemaBuilder addDateDayField(String fieldName) {
        this.fields.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.DATEDAY.getType()), null));
        return this;
    }

    public SchemaBuilder addDateMilliField(String fieldName) {
        this.fields.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.DATEMILLI.getType()), null));
        return this;
    }

    public SchemaBuilder addMetadata(String key, String value) {
        this.metadata.put((Object)key, (Object)value);
        return this;
    }

    public Field getField(String name) {
        return this.fields.get(name);
    }

    public FieldBuilder getNestedField(String name) {
        return this.nestedFieldBuilderMap.get(name);
    }

    public static SchemaBuilder newBuilder() {
        return new SchemaBuilder();
    }

    public Schema build() {
        for (Map.Entry<String, FieldBuilder> next : this.nestedFieldBuilderMap.entrySet()) {
            this.fields.put(next.getKey(), next.getValue().build());
        }
        return new Schema(this.fields.values(), (Map)this.metadata.build());
    }
}

