/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.domain.spill.SpillLocation;
import com.amazonaws.athena.connector.lambda.security.EncryptionKey;
import java.util.Objects;

public class SpillConfig {
    private static final int DEFAULT_SPILL_THREADS = 1;
    private final EncryptionKey encryptionKey;
    private final SpillLocation spillLocation;
    private final String requestId;
    private final long maxBlockBytes;
    private final long maxInlineBlockSize;
    private final int numSpillThreads;

    private SpillConfig(Builder builder) {
        this.encryptionKey = builder.encryptionKey;
        this.spillLocation = Objects.requireNonNull(builder.spillLocation, "spillLocation was null");
        this.requestId = Objects.requireNonNull(builder.requestId, "requestId was null");
        this.maxBlockBytes = builder.maxBlockBytes;
        this.maxInlineBlockSize = builder.maxInlineBlockSize;
        this.numSpillThreads = builder.numSpillThreads;
    }

    public EncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public SpillLocation getSpillLocation() {
        return this.spillLocation;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public long getMaxBlockBytes() {
        return this.maxBlockBytes;
    }

    public long getMaxInlineBlockSize() {
        return this.maxInlineBlockSize;
    }

    public int getNumSpillThreads() {
        return this.numSpillThreads;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(SpillConfig copy) {
        Builder builder = new Builder();
        builder.encryptionKey = copy.getEncryptionKey();
        builder.maxBlockBytes = copy.getMaxBlockBytes();
        return builder;
    }

    public static final class Builder {
        private EncryptionKey encryptionKey;
        private String requestId;
        private SpillLocation spillLocation;
        private long maxBlockBytes;
        private long maxInlineBlockSize;
        private int numSpillThreads = 1;

        private Builder() {
        }

        public Builder withEncryptionKey(EncryptionKey val) {
            this.encryptionKey = val;
            return this;
        }

        public Builder withRequestId(String val) {
            this.requestId = val;
            return this;
        }

        public Builder withSpillLocation(SpillLocation val) {
            this.spillLocation = val;
            return this;
        }

        public Builder withNumSpillThreads(int val) {
            this.numSpillThreads = val;
            return this;
        }

        public Builder withMaxBlockBytes(long val) {
            this.maxBlockBytes = val;
            return this;
        }

        public Builder withMaxInlineBlockBytes(long val) {
            this.maxInlineBlockSize = val;
            return this;
        }

        public SpillConfig build() {
            return new SpillConfig(this);
        }
    }
}

