/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data.writers.fieldwriters;

import com.amazonaws.athena.connector.lambda.data.writers.extractors.BitExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.FieldWriter;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintProjector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.holders.NullableBitHolder;

public class BitFieldWriter
implements FieldWriter {
    private final NullableBitHolder holder = new NullableBitHolder();
    private final BitExtractor extractor;
    private final BitVector vector;
    private final ConstraintApplier constraint;

    public BitFieldWriter(BitExtractor extractor, BitVector vector, ConstraintProjector rawConstraint) {
        this.extractor = extractor;
        this.vector = vector;
        this.constraint = rawConstraint != null ? value -> rawConstraint.apply(value.isSet == 0 ? null : Boolean.valueOf(value.value > 0)) : value -> true;
    }

    @Override
    public boolean write(Object context, int rowNum) throws Exception {
        this.extractor.extract(context, this.holder);
        this.vector.setSafe(rowNum, this.holder);
        return this.constraint.apply(this.holder);
    }

    private static interface ConstraintApplier {
        public boolean apply(NullableBitHolder var1);
    }
}

