/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data.writers.fieldwriters;

import com.amazonaws.athena.connector.lambda.data.writers.extractors.VarBinaryExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.FieldWriter;
import com.amazonaws.athena.connector.lambda.data.writers.holders.NullableVarBinaryHolder;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintProjector;
import org.apache.arrow.vector.VarBinaryVector;

public class VarBinaryFieldWriter
implements FieldWriter {
    private final NullableVarBinaryHolder holder = new NullableVarBinaryHolder();
    private final VarBinaryExtractor extractor;
    private final VarBinaryVector vector;
    private final ConstraintApplier constraint;

    public VarBinaryFieldWriter(VarBinaryExtractor extractor, VarBinaryVector vector, ConstraintProjector rawConstraint) {
        this.extractor = extractor;
        this.vector = vector;
        this.constraint = rawConstraint != null ? value -> rawConstraint.apply(value.isSet == 0 ? null : value.value) : value -> true;
    }

    @Override
    public boolean write(Object context, int rowNum) throws Exception {
        this.extractor.extract(context, this.holder);
        if (this.holder.isSet > 0) {
            this.vector.setSafe(rowNum, this.holder.value);
        } else {
            this.vector.setNull(rowNum);
        }
        return this.constraint.apply(this.holder);
    }

    private static interface ConstraintApplier {
        public boolean apply(NullableVarBinaryHolder var1);
    }
}

