/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintProjector;
import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.domain.predicate.Marker;
import com.amazonaws.athena.connector.lambda.domain.predicate.MarkerFactory;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintEvaluator
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ConstraintEvaluator.class);
    private final Constraints constraints;
    private final MarkerFactory markerFactory;
    private final Map<String, ArrowType> typeMap = new HashMap<String, ArrowType>();

    public ConstraintEvaluator(BlockAllocator allocator, Schema schema, Constraints constraints) {
        this.constraints = constraints;
        for (Field next : schema.getFields()) {
            this.typeMap.put(next.getName(), next.getType());
        }
        this.markerFactory = new MarkerFactory(allocator);
    }

    public static ConstraintEvaluator emptyEvaluator() {
        return new ConstraintEvaluator(null, SchemaBuilder.newBuilder().build(), new Constraints(new HashMap<String, ValueSet>(), Collections.emptyList(), Collections.emptyList(), -1L));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean apply(String fieldName, Object value) {
        boolean bl;
        ValueSet constraint = this.constraints.getSummary().get(fieldName);
        if (constraint == null || this.typeMap.get(fieldName) == null) return true;
        Marker marker = this.markerFactory.createNullable(this.typeMap.get(fieldName), value, Marker.Bound.EXACTLY);
        try {
            bl = constraint.containsValue(marker);
            if (marker == null) return bl;
        }
        catch (Throwable throwable) {
            try {
                if (marker == null) throw throwable;
                try {
                    marker.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
            }
        }
        marker.close();
        return bl;
    }

    public Optional<ConstraintProjector> makeConstraintProjector(String fieldName) {
        ValueSet constraint = this.constraints.getSummary().get(fieldName);
        if (constraint != null && this.typeMap.get(fieldName) != null) {
            return Optional.of(value -> constraint.containsValue(value));
        }
        return Optional.empty();
    }

    @Override
    public void close() throws Exception {
        this.markerFactory.close();
    }
}

