/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate.expression;

import com.amazonaws.athena.connector.lambda.domain.predicate.expression.FederationExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.ArrowType;

public class VariableExpression
extends FederationExpression {
    private final String columnName;

    @JsonCreator
    public VariableExpression(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="type") ArrowType type) {
        super(type);
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        if (columnName.isEmpty()) {
            throw new IllegalArgumentException("columnName is empty");
        }
    }

    @JsonProperty(value="columnName")
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public List<? extends FederationExpression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.columnName, this.getType());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableExpression that = (VariableExpression)o;
        return Objects.equals(this.columnName, that.columnName) && Objects.equals(this.getType(), that.getType());
    }

    @Override
    public String toString() {
        return this.columnName + "::" + this.getType();
    }
}

