/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.metadata.glue;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;

public class DefaultGlueType {
    private static final String TIMESTAMPMILLITZ = "timestamptz";
    private static final Set<String> NON_COMPARABALE_SET = ImmutableSet.of((Object)"TIMESTAMPMILLITZ");
    private static final Map<String, ArrowType> TYPE_MAP = new ImmutableMap.Builder().put((Object)"int", (Object)Types.MinorType.INT.getType()).put((Object)"varchar", (Object)Types.MinorType.VARCHAR.getType()).put((Object)"string", (Object)Types.MinorType.VARCHAR.getType()).put((Object)"bigint", (Object)Types.MinorType.BIGINT.getType()).put((Object)"double", (Object)Types.MinorType.FLOAT8.getType()).put((Object)"float", (Object)Types.MinorType.FLOAT4.getType()).put((Object)"smallint", (Object)Types.MinorType.SMALLINT.getType()).put((Object)"tinyint", (Object)Types.MinorType.TINYINT.getType()).put((Object)"boolean", (Object)Types.MinorType.BIT.getType()).put((Object)"binary", (Object)Types.MinorType.VARBINARY.getType()).put((Object)"timestamp", (Object)Types.MinorType.DATEMILLI.getType()).put((Object)"date", (Object)Types.MinorType.DATEDAY.getType()).put((Object)"timestamptz", (Object)new ArrowType.Timestamp(TimeUnit.MILLISECOND, ZoneId.systemDefault().getId())).build();
    private static final Pattern decimalPattern = Pattern.compile("decimal([(](([0-9]+,?){2,3})[)])?");
    private String id;
    private ArrowType arrowType;

    DefaultGlueType(String id, ArrowType arrowType) {
        this.id = id;
        this.arrowType = arrowType;
    }

    private static ArrowType getDecimalArrowType(String in) {
        Matcher decimalMatcher = decimalPattern.matcher(in);
        if (!decimalMatcher.matches()) {
            return null;
        }
        try {
            int[] params = Arrays.stream(decimalMatcher.group(2).split(",")).mapToInt(Integer::parseInt).toArray();
            if (params.length == 2) {
                return new ArrowType.Decimal(params[0], params[1]);
            }
            return new ArrowType.Decimal(params[0], params[1], params[2]);
        }
        catch (NullPointerException e) {
            return new ArrowType.Decimal(38, 18);
        }
    }

    public static ArrowType fromId(String id) {
        ArrowType result = DefaultGlueType.toArrowType(id);
        if (result == null) {
            throw new IllegalArgumentException("Unknown DefaultGlueType for id: " + id);
        }
        return result;
    }

    public static ArrowType toArrowType(String id) {
        ArrowType result = TYPE_MAP.get(id.toLowerCase());
        if (result == null) {
            return DefaultGlueType.getDecimalArrowType(id);
        }
        return result;
    }

    public ArrowType getArrowType() {
        return this.arrowType;
    }

    public static Set<String> getNonComparableSet() {
        return NON_COMPARABALE_SET;
    }
}

