/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.records;

import com.amazonaws.athena.connector.lambda.domain.Split;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.records.RecordRequest;
import com.amazonaws.athena.connector.lambda.records.RecordRequestType;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.Schema;

public class ReadRecordsRequest
extends RecordRequest {
    private final TableName tableName;
    private final Schema schema;
    private final Split split;
    private final Constraints constraints;
    private final long maxBlockSize;
    private final long maxInlineBlockSize;

    public ReadRecordsRequest(@JsonProperty(value="identity") FederatedIdentity identity, @JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="queryId") String queryId, @JsonProperty(value="tableName") TableName tableName, @JsonProperty(value="schema") Schema schema, @JsonProperty(value="split") Split split, @JsonProperty(value="constraints") Constraints constraints, @JsonProperty(value="maxBlockSize") long maxBlockSize, @JsonProperty(value="maxInlineBlockSize") long maxInlineBlockSize) {
        super(identity, RecordRequestType.READ_RECORDS, catalogName, queryId);
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(split, "split is null");
        Objects.requireNonNull(constraints, "constraints is null");
        this.schema = schema;
        this.tableName = tableName;
        this.split = split;
        this.maxBlockSize = maxBlockSize;
        this.maxInlineBlockSize = maxInlineBlockSize;
        this.constraints = constraints;
    }

    @JsonProperty
    public TableName getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public Schema getSchema() {
        return this.schema;
    }

    @JsonProperty
    public Split getSplit() {
        return this.split;
    }

    @JsonProperty
    public long getMaxInlineBlockSize() {
        return this.maxInlineBlockSize;
    }

    @JsonProperty
    public long getMaxBlockSize() {
        return this.maxBlockSize;
    }

    @JsonProperty
    public Constraints getConstraints() {
        return this.constraints;
    }

    @Override
    public void close() throws Exception {
        this.constraints.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.getQueryId()).add("tableName", (Object)this.tableName).add("schema", (Object)this.schema).add("split", (Object)this.split).add("requestType", (Object)this.getRequestType()).add("catalogName", (Object)this.getCatalogName()).add("maxBlockSize", this.maxBlockSize).add("maxInlineBlockSize", this.maxInlineBlockSize).add("constraints", (Object)this.constraints).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadRecordsRequest that = (ReadRecordsRequest)o;
        return com.google.common.base.Objects.equal((Object)this.tableName, (Object)that.tableName) && com.google.common.base.Objects.equal((Object)this.schema, (Object)that.schema) && com.google.common.base.Objects.equal((Object)this.split, (Object)that.split) && com.google.common.base.Objects.equal((Object)this.constraints, (Object)that.constraints) && com.google.common.base.Objects.equal((Object)this.maxBlockSize, (Object)that.maxBlockSize) && com.google.common.base.Objects.equal((Object)this.maxInlineBlockSize, (Object)that.maxInlineBlockSize) && com.google.common.base.Objects.equal((Object)((Object)this.getRequestType()), (Object)((Object)that.getRequestType())) && com.google.common.base.Objects.equal((Object)this.getCatalogName(), (Object)that.getCatalogName()) && com.google.common.base.Objects.equal((Object)this.getQueryId(), (Object)that.getQueryId());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.tableName, this.schema, this.split, this.constraints, this.maxBlockSize, this.maxInlineBlockSize, this.getRequestType(), this.getCatalogName(), this.getQueryId()});
    }
}

