/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.security;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.RecordBatchSerDe;
import com.amazonaws.athena.connector.lambda.security.BlockCrypto;
import com.amazonaws.athena.connector.lambda.security.EncryptionKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.arrow.vector.types.pojo.Schema;

public class NoOpBlockCrypto
implements BlockCrypto {
    private final RecordBatchSerDe serDe;
    private final BlockAllocator allocator;

    public NoOpBlockCrypto(BlockAllocator allocator) {
        this.serDe = new RecordBatchSerDe(allocator);
        this.allocator = allocator;
    }

    @Override
    public byte[] encrypt(EncryptionKey key, Block block) {
        if (key != null) {
            throw new RuntimeException("Real key provided to NoOpBlockCrypto, likely indicates you wanted real crypto.");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.serDe.serialize(block.getRecordBatch(), out);
            return out.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Block decrypt(EncryptionKey key, byte[] bytes, Schema schema) {
        try {
            Block resultBlock = this.allocator.createBlock(schema);
            resultBlock.loadRecordBatch(this.serDe.deserialize(bytes));
            return resultBlock;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public byte[] decrypt(EncryptionKey key, byte[] bytes) {
        return bytes;
    }
}

