/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.amazonaws.athena.connector.lambda.serde.BaseDeserializer;
import com.amazonaws.athena.connector.lambda.serde.BaseSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class FederatedIdentitySerDe {
    private static final String ID_FIELD = "id";
    private static final String COMPATIBILITY_ID = "UNKNOWN";
    private static final String PRINCIPAL_FIELD = "principal";
    private static final String COMPATIBILITY_PRINCIPAL = "UNKNOWN";
    private static final String ACCOUNT_FIELD = "account";
    private static final String ARN_FIELD = "arn";
    private static final String TAGS_FIELD = "tags";
    private static final String GROUPS_FIELD = "groups";

    private FederatedIdentitySerDe() {
    }

    public static final class Deserializer
    extends BaseDeserializer<FederatedIdentity> {
        public Deserializer() {
            super(FederatedIdentity.class);
        }

        @Override
        public FederatedIdentity deserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            if (jparser.nextToken() != JsonToken.VALUE_NULL) {
                this.validateObjectStart(jparser.getCurrentToken());
                FederatedIdentity federatedIdentity = this.doDeserialize(jparser, ctxt);
                this.ignoreRestOfObject(jparser);
                return federatedIdentity;
            }
            return null;
        }

        @Override
        public FederatedIdentity doDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.getNextStringField(jparser, FederatedIdentitySerDe.ID_FIELD);
            this.getNextStringField(jparser, FederatedIdentitySerDe.PRINCIPAL_FIELD);
            String account = this.getNextStringField(jparser, FederatedIdentitySerDe.ACCOUNT_FIELD);
            String arn = this.getNextStringField(jparser, FederatedIdentitySerDe.ARN_FIELD);
            Map<String, String> principalTags = this.getNextStringMap(jparser, FederatedIdentitySerDe.TAGS_FIELD);
            List<String> groups = this.getNextStringArray(jparser, FederatedIdentitySerDe.GROUPS_FIELD);
            return new FederatedIdentity(arn, account, principalTags, groups);
        }
    }

    public static final class Serializer
    extends BaseSerializer<FederatedIdentity> {
        public Serializer() {
            super(FederatedIdentity.class);
        }

        @Override
        public void doSerialize(FederatedIdentity federatedIdentity, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStringField(FederatedIdentitySerDe.ID_FIELD, "UNKNOWN");
            jgen.writeStringField(FederatedIdentitySerDe.PRINCIPAL_FIELD, "UNKNOWN");
            jgen.writeStringField(FederatedIdentitySerDe.ACCOUNT_FIELD, federatedIdentity.getAccount());
            jgen.writeStringField(FederatedIdentitySerDe.ARN_FIELD, federatedIdentity.getArn());
            this.writeStringMap(jgen, FederatedIdentitySerDe.TAGS_FIELD, federatedIdentity.getPrincipalTags());
            this.writeStringArray(jgen, FederatedIdentitySerDe.GROUPS_FIELD, federatedIdentity.getIamGroups());
        }
    }
}

