/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.metadata.GetTableLayoutResponse;
import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.amazonaws.athena.connector.lambda.serde.VersionedSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.TableNameSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;

public final class GetTableLayoutResponseSerDe {
    private static final String CATALOG_NAME_FIELD = "catalogName";
    private static final String TABLE_NAME_FIELD = "tableName";
    private static final String PARTITIONS_FIELD = "partitions";

    private GetTableLayoutResponseSerDe() {
    }

    public static final class Deserializer
    extends TypedDeserializer<FederationResponse> {
        private final TableNameSerDe.Deserializer tableNameDeserializer;
        private final VersionedSerDe.Deserializer<Block> blockDeserializer;

        public Deserializer(TableNameSerDe.Deserializer tableNameDeserializer, VersionedSerDe.Deserializer<Block> blockDeserializer) {
            super(FederationResponse.class, GetTableLayoutResponse.class);
            this.tableNameDeserializer = Objects.requireNonNull(tableNameDeserializer, "tableNameDeserializer is null");
            this.blockDeserializer = Objects.requireNonNull(blockDeserializer, "blockDeserializer is null");
        }

        @Override
        protected FederationResponse doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            String catalogName = this.getNextStringField(jparser, GetTableLayoutResponseSerDe.CATALOG_NAME_FIELD);
            this.assertFieldName(jparser, GetTableLayoutResponseSerDe.TABLE_NAME_FIELD);
            TableName tableName = (TableName)this.tableNameDeserializer.deserialize(jparser, ctxt);
            this.assertFieldName(jparser, GetTableLayoutResponseSerDe.PARTITIONS_FIELD);
            Block partitions = this.blockDeserializer.deserialize(jparser, ctxt);
            return new GetTableLayoutResponse(catalogName, tableName, partitions);
        }
    }

    public static final class Serializer
    extends TypedSerializer<FederationResponse> {
        private final TableNameSerDe.Serializer tableNameSerializer;
        private final VersionedSerDe.Serializer<Block> blockSerializer;

        public Serializer(TableNameSerDe.Serializer tableNameSerializer, VersionedSerDe.Serializer<Block> blockSerializer) {
            super(FederationResponse.class, GetTableLayoutResponse.class);
            this.tableNameSerializer = Objects.requireNonNull(tableNameSerializer, "tableNameSerializer is null");
            this.blockSerializer = Objects.requireNonNull(blockSerializer, "blockSerDe is null");
        }

        @Override
        protected void doTypedSerialize(FederationResponse federationResponse, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            GetTableLayoutResponse getTableLayoutResponse = (GetTableLayoutResponse)federationResponse;
            jgen.writeStringField(GetTableLayoutResponseSerDe.CATALOG_NAME_FIELD, getTableLayoutResponse.getCatalogName());
            jgen.writeFieldName(GetTableLayoutResponseSerDe.TABLE_NAME_FIELD);
            this.tableNameSerializer.serialize(getTableLayoutResponse.getTableName(), jgen, provider);
            jgen.writeFieldName(GetTableLayoutResponseSerDe.PARTITIONS_FIELD);
            this.blockSerializer.serialize(getTableLayoutResponse.getPartitions(), jgen, provider);
        }
    }
}

