/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v3;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorRegistry;
import com.amazonaws.athena.connector.lambda.serde.BaseDeserializer;
import com.amazonaws.athena.connector.lambda.serde.BaseSerializer;
import com.amazonaws.athena.connector.lambda.serde.VersionedSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.Schema;

public class BlockSerDeV3 {
    private static final String ALLOCATOR_ID_FIELD_NAME = "aId";
    private static final String SCHEMA_FIELD_NAME = "schema";
    private static final String BATCH_FIELD_NAME = "records";

    public static final class Deserializer
    extends BaseDeserializer<Block>
    implements VersionedSerDe.Deserializer<Block> {
        private final BlockAllocator allocator;
        private final BlockAllocatorRegistry allocatorRegistry;
        private VersionedSerDe.Deserializer<Schema> schemaDeserializer;

        public Deserializer(BlockAllocator allocator, VersionedSerDe.Deserializer<Schema> schemaDeserializer) {
            super(Block.class);
            this.schemaDeserializer = Objects.requireNonNull(schemaDeserializer, "schemaDeserializer is null");
            this.allocator = allocator;
            this.allocatorRegistry = null;
        }

        Deserializer(BlockAllocatorRegistry allocatorRegistry, VersionedSerDe.Deserializer<Schema> schemaDeserializer) {
            super(Block.class);
            this.schemaDeserializer = Objects.requireNonNull(schemaDeserializer, "schemaDeserializer is null");
            this.allocator = null;
            this.allocatorRegistry = Objects.requireNonNull(allocatorRegistry, "allocatorRegistry is null");
        }

        @Override
        public Block doDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            String allocatorId = this.getNextStringField(jparser, BlockSerDeV3.ALLOCATOR_ID_FIELD_NAME);
            this.assertFieldName(jparser, BlockSerDeV3.SCHEMA_FIELD_NAME);
            Schema schema = this.schemaDeserializer.deserialize(jparser, ctxt);
            byte[] batchBytes = this.getNextBinaryField(jparser, BlockSerDeV3.BATCH_FIELD_NAME);
            Block block = this.getOrCreateAllocator(allocatorId).createBlock(schema);
            if (batchBytes.length > 0) {
                ArrowRecordBatch batch = this.deserializeBatch(allocatorId, batchBytes);
                block.loadRecordBatch(batch);
            }
            return block;
        }

        private BlockAllocator getOrCreateAllocator(String allocatorId) {
            if (this.allocator != null) {
                return this.allocator;
            }
            if (this.allocatorRegistry != null) {
                return this.allocatorRegistry.getOrCreateAllocator(allocatorId);
            }
            throw new IllegalStateException("allocator and allocatorRegistry are both null");
        }

        private ArrowRecordBatch deserializeBatch(String allocatorId, byte[] batchBytes) throws IOException {
            return this.deserializeRecordBatch(this.getOrCreateAllocator(allocatorId), batchBytes);
        }

        private ArrowRecordBatch deserializeRecordBatch(BlockAllocator allocator, byte[] in) {
            AtomicReference batch = new AtomicReference();
            try {
                return allocator.registerBatch(root -> {
                    batch.set((ArrowRecordBatch)MessageSerializer.deserializeMessageBatch((ReadChannel)new ReadChannel(Channels.newChannel(new ByteArrayInputStream(in))), (BufferAllocator)root));
                    return (ArrowRecordBatch)batch.get();
                });
            }
            catch (Exception ex) {
                if (batch.get() != null) {
                    ((ArrowRecordBatch)batch.get()).close();
                }
                throw ex;
            }
        }
    }

    public static final class Serializer
    extends BaseSerializer<Block>
    implements VersionedSerDe.Serializer<Block> {
        private final VersionedSerDe.Serializer<Schema> schemaSerializer;

        public Serializer(VersionedSerDe.Serializer<Schema> schemaSerializer) {
            super(Block.class);
            this.schemaSerializer = Objects.requireNonNull(schemaSerializer, "schemaSerializer is null");
        }

        @Override
        public void doSerialize(Block block, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStringField(BlockSerDeV3.ALLOCATOR_ID_FIELD_NAME, block.getAllocatorId());
            jgen.writeFieldName(BlockSerDeV3.SCHEMA_FIELD_NAME);
            this.schemaSerializer.serialize(block.getSchema(), jgen, provider);
            jgen.writeFieldName(BlockSerDeV3.BATCH_FIELD_NAME);
            if (block.getRowCount() > 0) {
                jgen.writeBinary(this.serializeRecordBatch(block.getRecordBatch()));
            } else {
                jgen.writeString("");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] serializeRecordBatch(ArrowRecordBatch recordBatch) throws IOException {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                MessageSerializer.serialize((WriteChannel)new WriteChannel(Channels.newChannel(out)), (ArrowRecordBatch)recordBatch);
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            finally {
                recordBatch.close();
            }
        }
    }
}

