/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v4;

import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.domain.predicate.OrderByField;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueSet;
import com.amazonaws.athena.connector.lambda.domain.predicate.expression.FederationExpression;
import com.amazonaws.athena.connector.lambda.serde.BaseDeserializer;
import com.amazonaws.athena.connector.lambda.serde.BaseSerializer;
import com.amazonaws.athena.connector.lambda.serde.VersionedSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.ValueSetSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ConstraintsSerDeV4 {
    private static final String SUMMARY_FIELD = "summary";
    private static final String EXPRESSION_FIELD = "expression";
    private static final String ORDER_BY_CLAUSE = "orderByClause";
    private static final String LIMIT_FIELD = "limit";

    private ConstraintsSerDeV4() {
    }

    public static final class Deserializer
    extends BaseDeserializer<Constraints>
    implements VersionedSerDe.Deserializer<Constraints> {
        private final ValueSetSerDe.Deserializer valueSetDeserializer;
        private final VersionedSerDe.Deserializer<FederationExpression> federationExpressionDeserializer;
        private final VersionedSerDe.Deserializer<OrderByField> orderByFieldDeserializer;

        public Deserializer(ValueSetSerDe.Deserializer valueSetDeserializer, VersionedSerDe.Deserializer<FederationExpression> federationExpressionDeserializer, VersionedSerDe.Deserializer<OrderByField> orderByFieldDeserializer) {
            super(Constraints.class);
            this.valueSetDeserializer = Objects.requireNonNull(valueSetDeserializer, "valueSetSerDe is null");
            this.federationExpressionDeserializer = Objects.requireNonNull(federationExpressionDeserializer, "federationExpressionSerDe is null");
            this.orderByFieldDeserializer = Objects.requireNonNull(orderByFieldDeserializer, "orderByFieldSerDe is null");
        }

        @Override
        public Constraints doDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.assertFieldName(jparser, ConstraintsSerDeV4.SUMMARY_FIELD);
            this.validateObjectStart(jparser.nextToken());
            ImmutableMap.Builder summaryMap = ImmutableMap.builder();
            while (jparser.nextToken() != JsonToken.END_OBJECT) {
                String column = jparser.getCurrentName();
                summaryMap.put((Object)column, (Object)((ValueSet)this.valueSetDeserializer.deserialize(jparser, ctxt)));
            }
            this.assertFieldName(jparser, ConstraintsSerDeV4.EXPRESSION_FIELD);
            this.validateArrayStart(jparser);
            ImmutableList.Builder federationExpression = ImmutableList.builder();
            while (jparser.nextToken() != JsonToken.END_ARRAY) {
                this.validateObjectStart(jparser.getCurrentToken());
                federationExpression.add((Object)this.federationExpressionDeserializer.doDeserialize(jparser, ctxt));
                this.validateObjectEnd(jparser);
            }
            this.assertFieldName(jparser, ConstraintsSerDeV4.ORDER_BY_CLAUSE);
            this.validateArrayStart(jparser);
            ImmutableList.Builder orderByClauseBuilder = ImmutableList.builder();
            while (jparser.nextToken() != JsonToken.END_ARRAY) {
                this.validateObjectStart(jparser.getCurrentToken());
                orderByClauseBuilder.add((Object)this.orderByFieldDeserializer.doDeserialize(jparser, ctxt));
                this.validateObjectEnd(jparser);
            }
            long limit = this.getNextLongField(jparser, ConstraintsSerDeV4.LIMIT_FIELD);
            return new Constraints((Map<String, ValueSet>)summaryMap.build(), (List<FederationExpression>)federationExpression.build(), (List<OrderByField>)orderByClauseBuilder.build(), limit);
        }
    }

    public static final class Serializer
    extends BaseSerializer<Constraints>
    implements VersionedSerDe.Serializer<Constraints> {
        private final ValueSetSerDe.Serializer valueSetSerializer;
        private final VersionedSerDe.Serializer<FederationExpression> federationExpressionSerializer;
        private final VersionedSerDe.Serializer<OrderByField> orderByFieldSerializer;

        public Serializer(ValueSetSerDe.Serializer valueSetSerializer, VersionedSerDe.Serializer<FederationExpression> federationExpressionSerializer, VersionedSerDe.Serializer<OrderByField> orderByFieldSerializer) {
            super(Constraints.class);
            this.valueSetSerializer = Objects.requireNonNull(valueSetSerializer, "valueSetSerDe is null");
            this.federationExpressionSerializer = Objects.requireNonNull(federationExpressionSerializer, "federationExpressionSerDe is null");
            this.orderByFieldSerializer = Objects.requireNonNull(orderByFieldSerializer, "orderByFieldSerDe is null");
        }

        @Override
        public void doSerialize(Constraints constraints, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObjectFieldStart(ConstraintsSerDeV4.SUMMARY_FIELD);
            for (Map.Entry<String, ValueSet> entry : constraints.getSummary().entrySet()) {
                jgen.writeFieldName(entry.getKey());
                this.valueSetSerializer.serialize(entry.getValue(), jgen, provider);
            }
            jgen.writeEndObject();
            jgen.writeArrayFieldStart(ConstraintsSerDeV4.EXPRESSION_FIELD);
            for (FederationExpression federationExpression : constraints.getExpression()) {
                this.federationExpressionSerializer.serialize(federationExpression, jgen, provider);
            }
            jgen.writeEndArray();
            jgen.writeArrayFieldStart(ConstraintsSerDeV4.ORDER_BY_CLAUSE);
            for (OrderByField orderByField : constraints.getOrderByClause()) {
                this.orderByFieldSerializer.serialize(orderByField, jgen, provider);
            }
            jgen.writeEndArray();
            jgen.writeNumberField(ConstraintsSerDeV4.LIMIT_FIELD, constraints.getLimit());
        }
    }
}

