/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk;

import com.amazonaws.encryptionsdk.CryptoResult;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import com.amazonaws.encryptionsdk.internal.MessageCryptoHandler;
import com.amazonaws.encryptionsdk.internal.Utils;
import java.io.IOException;
import java.io.OutputStream;

public class CryptoOutputStream<K extends MasterKey<K>>
extends OutputStream {
    private final OutputStream outputStream_;
    private int lastProcessedLen_ = 0;
    private byte[] outBytes_ = new byte[0];
    private final MessageCryptoHandler<K> cryptoHandler_;

    CryptoOutputStream(OutputStream outputStream, MessageCryptoHandler<K> cryptoHandler) {
        this.outputStream_ = Utils.assertNonNull(outputStream, "outputStream");
        this.cryptoHandler_ = Utils.assertNonNull(cryptoHandler, "cryptoHandler");
    }

    @Override
    public void write(byte[] b) throws IllegalArgumentException, IOException, BadCiphertextException {
        if (b == null) {
            throw new IllegalArgumentException("b cannot be null");
        }
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IllegalArgumentException, IOException, BadCiphertextException {
        if (b == null) {
            throw new IllegalArgumentException("b cannot be null");
        }
        if (len < 0 || off < 0) {
            throw new IllegalArgumentException(String.format("Invalid values for offset: %d and length: %d", off, len));
        }
        int outLen = this.cryptoHandler_.estimateOutputSize(len);
        this.outBytes_ = new byte[outLen];
        this.lastProcessedLen_ = this.cryptoHandler_.processBytes(b, off, len, this.outBytes_, 0).getBytesWritten();
        if (this.lastProcessedLen_ > 0) {
            this.outputStream_.write(this.outBytes_, 0, this.lastProcessedLen_);
        }
    }

    @Override
    public void write(int b) throws IOException, BadCiphertextException {
        byte[] bArray = new byte[]{(byte)b};
        this.write(bArray, 0, 1);
    }

    @Override
    public void close() throws IOException, BadCiphertextException {
        if (this.outBytes_.length == 0) {
            this.outBytes_ = new byte[this.cryptoHandler_.estimateOutputSize(0)];
            this.lastProcessedLen_ = 0;
        }
        int finalLen = this.cryptoHandler_.doFinal(this.outBytes_, this.lastProcessedLen_);
        this.outputStream_.write(this.outBytes_, this.lastProcessedLen_, finalLen);
        this.outputStream_.close();
    }

    public CryptoResult<CryptoOutputStream<K>, K> getCryptoResult() {
        return new CryptoResult<CryptoOutputStream, K>(this, this.cryptoHandler_.getMasterKeys(), this.cryptoHandler_.getHeaders());
    }
}

