/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MasterKeyRequest {
    private final Map<String, String> encryptionContext_;
    private final boolean isStreaming_;
    private final byte[] plaintext_;
    private final long size_;

    private MasterKeyRequest(Map<String, String> encryptionContext, boolean isStreaming, byte[] plaintext, long size) {
        this.encryptionContext_ = encryptionContext;
        this.isStreaming_ = isStreaming;
        this.plaintext_ = plaintext;
        this.size_ = size;
    }

    public Map<String, String> getEncryptionContext() {
        return this.encryptionContext_;
    }

    public boolean isStreaming() {
        return this.isStreaming_;
    }

    public byte[] getPlaintext() {
        return this.plaintext_ != null ? (byte[])this.plaintext_.clone() : null;
    }

    public long getSize() {
        return this.size_;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Map<String, String> encryptionContext_ = new HashMap<String, String>();
        private boolean isStreaming_ = false;
        private byte[] plaintext_ = null;
        private long size_ = -1L;

        public Map<String, String> getEncryptionContext() {
            return this.encryptionContext_;
        }

        public Builder setEncryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext_ = encryptionContext;
            return this;
        }

        public boolean isStreaming() {
            return this.isStreaming_;
        }

        public Builder setStreaming(boolean isStreaming) {
            this.isStreaming_ = isStreaming;
            return this;
        }

        public byte[] getPlaintext() {
            return this.plaintext_;
        }

        public Builder setPlaintext(byte[] plaintext) {
            if (this.size_ != -1L) {
                throw new IllegalStateException("The plaintext may only be set if the size has not been explicitly set");
            }
            this.plaintext_ = plaintext;
            return this;
        }

        public Builder setSize(long size) {
            if (this.plaintext_ != null) {
                throw new IllegalStateException("Size may only explicitly set when the plaintext is not set");
            }
            this.size_ = size;
            return this;
        }

        public long getSize() {
            return this.size_;
        }

        public MasterKeyRequest build() {
            return new MasterKeyRequest(Collections.unmodifiableMap(new HashMap<String, String>(this.encryptionContext_)), this.isStreaming_, this.plaintext_, this.plaintext_ != null ? (long)this.plaintext_.length : this.size_);
        }
    }
}

