/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk;

import com.amazonaws.encryptionsdk.CommitmentPolicy;
import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.CryptoInputStream;
import com.amazonaws.encryptionsdk.CryptoMaterialsManager;
import com.amazonaws.encryptionsdk.CryptoOutputStream;
import com.amazonaws.encryptionsdk.CryptoResult;
import com.amazonaws.encryptionsdk.DefaultCryptoMaterialsManager;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.ParsedCiphertext;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import com.amazonaws.encryptionsdk.internal.DecryptionHandler;
import com.amazonaws.encryptionsdk.internal.EncryptionHandler;
import com.amazonaws.encryptionsdk.internal.LazyMessageCryptoHandler;
import com.amazonaws.encryptionsdk.internal.MessageCryptoHandler;
import com.amazonaws.encryptionsdk.internal.ProcessingSummary;
import com.amazonaws.encryptionsdk.internal.SignaturePolicy;
import com.amazonaws.encryptionsdk.internal.Utils;
import com.amazonaws.encryptionsdk.model.EncryptionMaterials;
import com.amazonaws.encryptionsdk.model.EncryptionMaterialsRequest;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;

public class AwsCrypto {
    private static final Logger LOGGER = Logger.getLogger(AwsCrypto.class.getName());
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private volatile CryptoAlgorithm encryptionAlgorithm_ = null;
    private volatile int encryptionFrameSize_ = AwsCrypto.getDefaultFrameSize();
    private final CommitmentPolicy commitmentPolicy_;
    private final int maxEncryptedDataKeys_;

    private static void warn_end_of_support() {
        LOGGER.warning("This major version (1.x) of the AWS Encryption SDK for Java has reached End-of-Support.\nIt will no longer receive security updates or bug fixes.\nConsider updating to the latest version of the AWS Encryption SDK.");
    }

    @Deprecated
    public AwsCrypto() {
        AwsCrypto.warn_end_of_support();
        this.commitmentPolicy_ = CommitmentPolicy.ForbidEncryptAllowDecrypt;
        this.maxEncryptedDataKeys_ = 0;
    }

    private AwsCrypto(Builder builder) {
        AwsCrypto.warn_end_of_support();
        if (builder.commitmentPolicy_ == null) {
            throw new IllegalArgumentException("Must specify a commitment policy on the client.");
        }
        if (builder.encryptionAlgorithm_ != null && builder.encryptionAlgorithm_.getMessageFormatVersion() != 1) {
            throw new AwsCryptoException("Configuration conflict. Cannot encrypt due to CommitmentPolicy " + (Object)((Object)builder.commitmentPolicy_) + " requiring only non-committed messages. Algorithm ID was " + (Object)((Object)builder.encryptionAlgorithm_) + ". See: https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/troubleshooting-migration.html");
        }
        this.encryptionAlgorithm_ = builder.encryptionAlgorithm_;
        this.encryptionFrameSize_ = builder.encryptionFrameSize_;
        this.commitmentPolicy_ = builder.commitmentPolicy_;
        this.maxEncryptedDataKeys_ = builder.maxEncryptedDataKeys_;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Deprecated
    public static CryptoAlgorithm getDefaultCryptoAlgorithm() {
        return CryptoAlgorithm.ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384;
    }

    public static int getDefaultFrameSize() {
        return 4096;
    }

    public void setEncryptionAlgorithm(CryptoAlgorithm alg) {
        if (alg.getMessageFormatVersion() != 1) {
            throw new AwsCryptoException("Configuration conflict. Cannot encrypt due to CommitmentPolicy " + (Object)((Object)this.commitmentPolicy_) + " requiring only non-committed messages. Algorithm ID was " + (Object)((Object)alg) + ". See: https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/troubleshooting-migration.html");
        }
        this.encryptionAlgorithm_ = alg;
    }

    public CryptoAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm_;
    }

    public void setEncryptionFrameSize(int frameSize) {
        if (frameSize < 0) {
            throw new IllegalArgumentException("frameSize must be non-negative");
        }
        this.encryptionFrameSize_ = frameSize;
    }

    public int getEncryptionFrameSize() {
        return this.encryptionFrameSize_;
    }

    public <K extends MasterKey<K>> long estimateCiphertextSize(MasterKeyProvider<K> provider, int plaintextSize, Map<String, String> encryptionContext) {
        return this.estimateCiphertextSize(new DefaultCryptoMaterialsManager(provider), plaintextSize, encryptionContext);
    }

    public long estimateCiphertextSize(CryptoMaterialsManager materialsManager, int plaintextSize, Map<String, String> encryptionContext) {
        EncryptionMaterialsRequest request = EncryptionMaterialsRequest.newBuilder().setContext(encryptionContext).setRequestedAlgorithm(this.getEncryptionAlgorithm()).setPlaintextSize(0L).build();
        EncryptionHandler cryptoHandler = new EncryptionHandler(this.getEncryptionFrameSize(), this.checkAlgorithm(materialsManager.getMaterialsForEncrypt(request)));
        return cryptoHandler.estimateOutputSize(plaintextSize);
    }

    public <K extends MasterKey<K>> long estimateCiphertextSize(MasterKeyProvider<K> provider, int plaintextSize) {
        return this.estimateCiphertextSize(provider, plaintextSize, EMPTY_MAP);
    }

    public long estimateCiphertextSize(CryptoMaterialsManager materialsManager, int plaintextSize) {
        return this.estimateCiphertextSize(materialsManager, plaintextSize, EMPTY_MAP);
    }

    public <K extends MasterKey<K>> CryptoResult<byte[], K> encryptData(MasterKeyProvider<K> provider, byte[] plaintext, Map<String, String> encryptionContext) {
        return this.encryptData(new DefaultCryptoMaterialsManager(provider), plaintext, encryptionContext);
    }

    public CryptoResult<byte[], ?> encryptData(CryptoMaterialsManager materialsManager, byte[] plaintext, Map<String, String> encryptionContext) {
        EncryptionMaterialsRequest request = EncryptionMaterialsRequest.newBuilder().setContext(encryptionContext).setRequestedAlgorithm(this.getEncryptionAlgorithm()).setPlaintext(plaintext).build();
        EncryptionMaterials encryptionMaterials = this.checkMaxEncryptedDataKeys(this.checkAlgorithm(materialsManager.getMaterialsForEncrypt(request)));
        EncryptionHandler cryptoHandler = new EncryptionHandler(this.getEncryptionFrameSize(), encryptionMaterials);
        int outSizeEstimate = cryptoHandler.estimateOutputSize(plaintext.length);
        byte[] out = new byte[outSizeEstimate];
        int outLen = cryptoHandler.processBytes(plaintext, 0, plaintext.length, out, 0).getBytesWritten();
        outLen += cryptoHandler.doFinal(out, outLen);
        byte[] outBytes = Utils.truncate(out, outLen);
        return new CryptoResult(outBytes, cryptoHandler.getMasterKeys(), cryptoHandler.getHeaders());
    }

    public <K extends MasterKey<K>> CryptoResult<byte[], K> encryptData(MasterKeyProvider<K> provider, byte[] plaintext) {
        return this.encryptData(provider, plaintext, EMPTY_MAP);
    }

    public CryptoResult<byte[], ?> encryptData(CryptoMaterialsManager materialsManager, byte[] plaintext) {
        return this.encryptData(materialsManager, plaintext, EMPTY_MAP);
    }

    @Deprecated
    public <K extends MasterKey<K>> CryptoResult<String, K> encryptString(MasterKeyProvider<K> provider, String plaintext, Map<String, String> encryptionContext) {
        return this.encryptString(new DefaultCryptoMaterialsManager(provider), plaintext, encryptionContext);
    }

    @Deprecated
    public CryptoResult<String, ?> encryptString(CryptoMaterialsManager materialsManager, String plaintext, Map<String, String> encryptionContext) {
        CryptoResult<byte[], ?> ctBytes = this.encryptData(materialsManager, plaintext.getBytes(StandardCharsets.UTF_8), encryptionContext);
        return new CryptoResult(Utils.encodeBase64String(ctBytes.getResult()), ctBytes.getMasterKeys(), ctBytes.getHeaders());
    }

    @Deprecated
    public <K extends MasterKey<K>> CryptoResult<String, K> encryptString(MasterKeyProvider<K> provider, String plaintext) {
        return this.encryptString(provider, plaintext, EMPTY_MAP);
    }

    @Deprecated
    public CryptoResult<String, ?> encryptString(CryptoMaterialsManager materialsManager, String plaintext) {
        return this.encryptString(materialsManager, plaintext, EMPTY_MAP);
    }

    public <K extends MasterKey<K>> CryptoResult<byte[], K> decryptData(MasterKeyProvider<K> provider, byte[] ciphertext) {
        return this.decryptData(Utils.assertNonNull(provider, "provider"), new ParsedCiphertext(ciphertext, this.maxEncryptedDataKeys_));
    }

    public CryptoResult<byte[], ?> decryptData(CryptoMaterialsManager materialsManager, byte[] ciphertext) {
        return this.decryptData(Utils.assertNonNull(materialsManager, "materialsManager"), new ParsedCiphertext(ciphertext, this.maxEncryptedDataKeys_));
    }

    public <K extends MasterKey<K>> CryptoResult<byte[], K> decryptData(MasterKeyProvider<K> provider, ParsedCiphertext ciphertext) {
        Utils.assertNonNull(provider, "provider");
        return this.decryptData((CryptoMaterialsManager)new DefaultCryptoMaterialsManager(provider), ciphertext);
    }

    public CryptoResult<byte[], ?> decryptData(CryptoMaterialsManager materialsManager, ParsedCiphertext ciphertext) {
        Utils.assertNonNull(materialsManager, "materialsManager");
        DecryptionHandler<?> cryptoHandler = DecryptionHandler.create(materialsManager, ciphertext, this.commitmentPolicy_, SignaturePolicy.AllowEncryptAllowDecrypt, this.maxEncryptedDataKeys_);
        byte[] ciphertextBytes = ciphertext.getCiphertext();
        int contentLen = ciphertextBytes.length - ciphertext.getOffset();
        int outSizeEstimate = cryptoHandler.estimateOutputSize(contentLen);
        byte[] out = new byte[outSizeEstimate];
        ProcessingSummary processed = cryptoHandler.processBytes(ciphertextBytes, ciphertext.getOffset(), contentLen, out, 0);
        if (processed.getBytesProcessed() != contentLen) {
            throw new BadCiphertextException("Unable to process entire ciphertext. May have trailing data.");
        }
        int outLen = processed.getBytesWritten();
        outLen += cryptoHandler.doFinal(out, outLen);
        byte[] outBytes = Utils.truncate(out, outLen);
        return new CryptoResult(outBytes, cryptoHandler.getMasterKeys(), cryptoHandler.getHeaders());
    }

    @Deprecated
    public <K extends MasterKey<K>> CryptoResult<String, K> decryptString(MasterKeyProvider<K> provider, String ciphertext) {
        return this.decryptString(new DefaultCryptoMaterialsManager(provider), ciphertext);
    }

    @Deprecated
    public CryptoResult<String, ?> decryptString(CryptoMaterialsManager provider, String ciphertext) {
        byte[] ciphertextBytes;
        Utils.assertNonNull(provider, "provider");
        try {
            ciphertextBytes = Utils.decodeBase64String(Utils.assertNonNull(ciphertext, "ciphertext"));
        }
        catch (IllegalArgumentException ex) {
            throw new BadCiphertextException("Invalid base 64", ex);
        }
        CryptoResult<byte[], ?> ptBytes = this.decryptData(provider, ciphertextBytes);
        return new CryptoResult(new String(ptBytes.getResult(), StandardCharsets.UTF_8), ptBytes.getMasterKeys(), ptBytes.getHeaders());
    }

    public <K extends MasterKey<K>> CryptoOutputStream<K> createEncryptingStream(MasterKeyProvider<K> provider, OutputStream os, Map<String, String> encryptionContext) {
        return this.createEncryptingStream((CryptoMaterialsManager)new DefaultCryptoMaterialsManager(provider), os, encryptionContext);
    }

    public CryptoOutputStream<?> createEncryptingStream(CryptoMaterialsManager materialsManager, OutputStream os, Map<String, String> encryptionContext) {
        return new CryptoOutputStream(os, this.getEncryptingStreamHandler(materialsManager, encryptionContext));
    }

    public <K extends MasterKey<K>> CryptoOutputStream<K> createEncryptingStream(MasterKeyProvider<K> provider, OutputStream os) {
        return this.createEncryptingStream(provider, os, EMPTY_MAP);
    }

    public CryptoOutputStream<?> createEncryptingStream(CryptoMaterialsManager materialsManager, OutputStream os) {
        return this.createEncryptingStream(materialsManager, os, EMPTY_MAP);
    }

    public <K extends MasterKey<K>> CryptoInputStream<K> createEncryptingStream(MasterKeyProvider<K> provider, InputStream is, Map<String, String> encryptionContext) {
        return this.createEncryptingStream((CryptoMaterialsManager)new DefaultCryptoMaterialsManager(provider), is, encryptionContext);
    }

    public CryptoInputStream<?> createEncryptingStream(CryptoMaterialsManager materialsManager, InputStream is, Map<String, String> encryptionContext) {
        MessageCryptoHandler cryptoHandler = this.getEncryptingStreamHandler(materialsManager, encryptionContext);
        return new CryptoInputStream(is, cryptoHandler);
    }

    public <K extends MasterKey<K>> CryptoInputStream<K> createEncryptingStream(MasterKeyProvider<K> provider, InputStream is) {
        return this.createEncryptingStream(provider, is, EMPTY_MAP);
    }

    public CryptoInputStream<?> createEncryptingStream(CryptoMaterialsManager materialsManager, InputStream is) {
        return this.createEncryptingStream(materialsManager, is, EMPTY_MAP);
    }

    public <K extends MasterKey<K>> CryptoOutputStream<K> createUnsignedMessageDecryptingStream(MasterKeyProvider<K> provider, OutputStream os) {
        DecryptionHandler<K> cryptoHandler = DecryptionHandler.create(provider, this.commitmentPolicy_, SignaturePolicy.AllowEncryptForbidDecrypt, this.maxEncryptedDataKeys_);
        return new CryptoOutputStream(os, cryptoHandler);
    }

    public <K extends MasterKey<K>> CryptoInputStream<K> createUnsignedMessageDecryptingStream(MasterKeyProvider<K> provider, InputStream is) {
        DecryptionHandler<K> cryptoHandler = DecryptionHandler.create(provider, this.commitmentPolicy_, SignaturePolicy.AllowEncryptForbidDecrypt, this.maxEncryptedDataKeys_);
        return new CryptoInputStream(is, cryptoHandler);
    }

    public CryptoOutputStream<?> createUnsignedMessageDecryptingStream(CryptoMaterialsManager materialsManager, OutputStream os) {
        DecryptionHandler<?> cryptoHandler = DecryptionHandler.create(materialsManager, this.commitmentPolicy_, SignaturePolicy.AllowEncryptForbidDecrypt, this.maxEncryptedDataKeys_);
        return new CryptoOutputStream(os, cryptoHandler);
    }

    public CryptoInputStream<?> createUnsignedMessageDecryptingStream(CryptoMaterialsManager materialsManager, InputStream is) {
        DecryptionHandler<?> cryptoHandler = DecryptionHandler.create(materialsManager, this.commitmentPolicy_, SignaturePolicy.AllowEncryptForbidDecrypt, this.maxEncryptedDataKeys_);
        return new CryptoInputStream(is, cryptoHandler);
    }

    public <K extends MasterKey<K>> CryptoOutputStream<K> createDecryptingStream(MasterKeyProvider<K> provider, OutputStream os) {
        DecryptionHandler<K> cryptoHandler = DecryptionHandler.create(provider, this.commitmentPolicy_, SignaturePolicy.AllowEncryptAllowDecrypt, this.maxEncryptedDataKeys_);
        return new CryptoOutputStream(os, cryptoHandler);
    }

    public <K extends MasterKey<K>> CryptoInputStream<K> createDecryptingStream(MasterKeyProvider<K> provider, InputStream is) {
        DecryptionHandler<K> cryptoHandler = DecryptionHandler.create(provider, this.commitmentPolicy_, SignaturePolicy.AllowEncryptAllowDecrypt, this.maxEncryptedDataKeys_);
        return new CryptoInputStream(is, cryptoHandler);
    }

    public CryptoOutputStream<?> createDecryptingStream(CryptoMaterialsManager materialsManager, OutputStream os) {
        DecryptionHandler<?> cryptoHandler = DecryptionHandler.create(materialsManager, this.commitmentPolicy_, SignaturePolicy.AllowEncryptAllowDecrypt, this.maxEncryptedDataKeys_);
        return new CryptoOutputStream(os, cryptoHandler);
    }

    public CryptoInputStream<?> createDecryptingStream(CryptoMaterialsManager materialsManager, InputStream is) {
        DecryptionHandler<?> cryptoHandler = DecryptionHandler.create(materialsManager, this.commitmentPolicy_, SignaturePolicy.AllowEncryptAllowDecrypt, this.maxEncryptedDataKeys_);
        return new CryptoInputStream(is, cryptoHandler);
    }

    private MessageCryptoHandler getEncryptingStreamHandler(CryptoMaterialsManager materialsManager, Map<String, String> encryptionContext) {
        Utils.assertNonNull(materialsManager, "materialsManager");
        Utils.assertNonNull(encryptionContext, "encryptionContext");
        EncryptionMaterialsRequest.Builder requestBuilder = EncryptionMaterialsRequest.newBuilder().setContext(encryptionContext).setRequestedAlgorithm(this.getEncryptionAlgorithm());
        return new LazyMessageCryptoHandler(info -> {
            if (info.getMaxInputSize() != -1L) {
                requestBuilder.setPlaintextSize(info.getMaxInputSize());
            }
            return new EncryptionHandler(this.getEncryptionFrameSize(), this.checkMaxEncryptedDataKeys(this.checkAlgorithm(materialsManager.getMaterialsForEncrypt(requestBuilder.build()))));
        });
    }

    private EncryptionMaterials checkAlgorithm(EncryptionMaterials result) {
        if (this.encryptionAlgorithm_ != null && result.getAlgorithm() != this.encryptionAlgorithm_) {
            throw new AwsCryptoException(String.format("Materials manager ignored requested algorithm; algorithm %s was set on AwsCrypto but %s was selected", new Object[]{this.encryptionAlgorithm_, result.getAlgorithm()}));
        }
        return result;
    }

    private EncryptionMaterials checkMaxEncryptedDataKeys(EncryptionMaterials materials) {
        if (this.maxEncryptedDataKeys_ > 0 && materials.getEncryptedDataKeys().size() > this.maxEncryptedDataKeys_) {
            throw new AwsCryptoException("Encrypted data keys exceed maxEncryptedDataKeys");
        }
        return materials;
    }

    public static class Builder {
        private CryptoAlgorithm encryptionAlgorithm_;
        private int encryptionFrameSize_ = AwsCrypto.getDefaultFrameSize();
        private CommitmentPolicy commitmentPolicy_;
        private int maxEncryptedDataKeys_ = 0;

        private Builder() {
        }

        private Builder(AwsCrypto client) {
            this.encryptionAlgorithm_ = client.encryptionAlgorithm_;
            this.encryptionFrameSize_ = client.encryptionFrameSize_;
            this.commitmentPolicy_ = client.commitmentPolicy_;
            this.maxEncryptedDataKeys_ = client.maxEncryptedDataKeys_;
        }

        public Builder withEncryptionAlgorithm(CryptoAlgorithm encryptionAlgorithm) {
            this.encryptionAlgorithm_ = encryptionAlgorithm;
            return this;
        }

        public Builder withEncryptionFrameSize(int frameSize) {
            this.encryptionFrameSize_ = frameSize;
            return this;
        }

        public Builder withCommitmentPolicy(CommitmentPolicy commitmentPolicy) {
            this.commitmentPolicy_ = commitmentPolicy;
            return this;
        }

        public Builder withMaxEncryptedDataKeys(int maxEncryptedDataKeys) {
            if (maxEncryptedDataKeys < 1) {
                throw new IllegalArgumentException("maxEncryptedDataKeys must be positive");
            }
            this.maxEncryptedDataKeys_ = maxEncryptedDataKeys;
            return this;
        }

        public AwsCrypto build() {
            return new AwsCrypto(this);
        }
    }
}

