/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.accessanalyzer;

import javax.annotation.Generated;

import com.amazonaws.services.accessanalyzer.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSAccessAnalyzer}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSAccessAnalyzer implements AWSAccessAnalyzer {

    protected AbstractAWSAccessAnalyzer() {
    }

    @Override
    public CreateAnalyzerResult createAnalyzer(CreateAnalyzerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateArchiveRuleResult createArchiveRule(CreateArchiveRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAnalyzerResult deleteAnalyzer(DeleteAnalyzerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteArchiveRuleResult deleteArchiveRule(DeleteArchiveRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAnalyzedResourceResult getAnalyzedResource(GetAnalyzedResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAnalyzerResult getAnalyzer(GetAnalyzerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetArchiveRuleResult getArchiveRule(GetArchiveRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFindingResult getFinding(GetFindingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAnalyzedResourcesResult listAnalyzedResources(ListAnalyzedResourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAnalyzersResult listAnalyzers(ListAnalyzersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListArchiveRulesResult listArchiveRules(ListArchiveRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFindingsResult listFindings(ListFindingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartResourceScanResult startResourceScan(StartResourceScanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateArchiveRuleResult updateArchiveRule(UpdateArchiveRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFindingsResult updateFindings(UpdateFindingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
