/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.accessanalyzer.model.NetworkOriginConfiguration;
import com.amazonaws.services.accessanalyzer.model.S3PublicAccessBlockConfiguration;
import com.amazonaws.services.accessanalyzer.model.transform.S3AccessPointConfigurationMarshaller;
import java.io.Serializable;

public class S3AccessPointConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String accessPointPolicy;
    private S3PublicAccessBlockConfiguration publicAccessBlock;
    private NetworkOriginConfiguration networkOrigin;

    public void setAccessPointPolicy(String accessPointPolicy) {
        this.accessPointPolicy = accessPointPolicy;
    }

    public String getAccessPointPolicy() {
        return this.accessPointPolicy;
    }

    public S3AccessPointConfiguration withAccessPointPolicy(String accessPointPolicy) {
        this.setAccessPointPolicy(accessPointPolicy);
        return this;
    }

    public void setPublicAccessBlock(S3PublicAccessBlockConfiguration publicAccessBlock) {
        this.publicAccessBlock = publicAccessBlock;
    }

    public S3PublicAccessBlockConfiguration getPublicAccessBlock() {
        return this.publicAccessBlock;
    }

    public S3AccessPointConfiguration withPublicAccessBlock(S3PublicAccessBlockConfiguration publicAccessBlock) {
        this.setPublicAccessBlock(publicAccessBlock);
        return this;
    }

    public void setNetworkOrigin(NetworkOriginConfiguration networkOrigin) {
        this.networkOrigin = networkOrigin;
    }

    public NetworkOriginConfiguration getNetworkOrigin() {
        return this.networkOrigin;
    }

    public S3AccessPointConfiguration withNetworkOrigin(NetworkOriginConfiguration networkOrigin) {
        this.setNetworkOrigin(networkOrigin);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccessPointPolicy() != null) {
            sb.append("AccessPointPolicy: ").append(this.getAccessPointPolicy()).append(",");
        }
        if (this.getPublicAccessBlock() != null) {
            sb.append("PublicAccessBlock: ").append(this.getPublicAccessBlock()).append(",");
        }
        if (this.getNetworkOrigin() != null) {
            sb.append("NetworkOrigin: ").append(this.getNetworkOrigin());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3AccessPointConfiguration)) {
            return false;
        }
        S3AccessPointConfiguration other = (S3AccessPointConfiguration)obj;
        if (other.getAccessPointPolicy() == null ^ this.getAccessPointPolicy() == null) {
            return false;
        }
        if (other.getAccessPointPolicy() != null && !other.getAccessPointPolicy().equals(this.getAccessPointPolicy())) {
            return false;
        }
        if (other.getPublicAccessBlock() == null ^ this.getPublicAccessBlock() == null) {
            return false;
        }
        if (other.getPublicAccessBlock() != null && !other.getPublicAccessBlock().equals(this.getPublicAccessBlock())) {
            return false;
        }
        if (other.getNetworkOrigin() == null ^ this.getNetworkOrigin() == null) {
            return false;
        }
        return other.getNetworkOrigin() == null || other.getNetworkOrigin().equals(this.getNetworkOrigin());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccessPointPolicy() == null ? 0 : this.getAccessPointPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getPublicAccessBlock() == null ? 0 : this.getPublicAccessBlock().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkOrigin() == null ? 0 : this.getNetworkOrigin().hashCode());
        return hashCode;
    }

    public S3AccessPointConfiguration clone() {
        try {
            return (S3AccessPointConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3AccessPointConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

