/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.certificatemanager.model.ListCertificatesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class ListCertificatesRequestMarshaller
implements Marshaller<Request<ListCertificatesRequest>, ListCertificatesRequest> {
    public Request<ListCertificatesRequest> marshall(ListCertificatesRequest listCertificatesRequest) {
        if (listCertificatesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listCertificatesRequest, "AWSCertificateManager");
        request.addHeader("X-Amz-Target", "CertificateManager.ListCertificates");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            List<String> certificateStatusesList = listCertificatesRequest.getCertificateStatuses();
            if (certificateStatusesList != null) {
                jsonGenerator.writeFieldName("CertificateStatuses");
                jsonGenerator.writeStartArray();
                for (String certificateStatusesListValue : certificateStatusesList) {
                    if (certificateStatusesListValue == null) continue;
                    jsonGenerator.writeValue(certificateStatusesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listCertificatesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listCertificatesRequest.getNextToken());
            }
            if (listCertificatesRequest.getMaxItems() != null) {
                jsonGenerator.writeFieldName("MaxItems").writeValue(listCertificatesRequest.getMaxItems().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

