/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.acmpca.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.acmpca.model.CustomExtension;

@SdkInternalApi
public class CustomExtensionMarshaller {
    private static final MarshallingInfo<String> OBJECTIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectIdentifier").build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<Boolean> CRITICAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Critical").build();
    private static final CustomExtensionMarshaller instance = new CustomExtensionMarshaller();

    public static CustomExtensionMarshaller getInstance() {
        return instance;
    }

    public void marshall(CustomExtension customExtension, ProtocolMarshaller protocolMarshaller) {
        if (customExtension == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)customExtension.getObjectIdentifier(), OBJECTIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)customExtension.getValue(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)customExtension.getCritical(), CRITICAL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

