/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.alexaforbusiness.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendAnnouncement" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SendAnnouncementResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The identifier of the announcement.
     * </p>
     */
    private String announcementArn;

    /**
     * <p>
     * The identifier of the announcement.
     * </p>
     * 
     * @param announcementArn
     *        The identifier of the announcement.
     */

    public void setAnnouncementArn(String announcementArn) {
        this.announcementArn = announcementArn;
    }

    /**
     * <p>
     * The identifier of the announcement.
     * </p>
     * 
     * @return The identifier of the announcement.
     */

    public String getAnnouncementArn() {
        return this.announcementArn;
    }

    /**
     * <p>
     * The identifier of the announcement.
     * </p>
     * 
     * @param announcementArn
     *        The identifier of the announcement.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SendAnnouncementResult withAnnouncementArn(String announcementArn) {
        setAnnouncementArn(announcementArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAnnouncementArn() != null)
            sb.append("AnnouncementArn: ").append(getAnnouncementArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SendAnnouncementResult == false)
            return false;
        SendAnnouncementResult other = (SendAnnouncementResult) obj;
        if (other.getAnnouncementArn() == null ^ this.getAnnouncementArn() == null)
            return false;
        if (other.getAnnouncementArn() != null && other.getAnnouncementArn().equals(this.getAnnouncementArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAnnouncementArn() == null) ? 0 : getAnnouncementArn().hashCode());
        return hashCode;
    }

    @Override
    public SendAnnouncementResult clone() {
        try {
            return (SendAnnouncementResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
