/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplifyuibuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.amplifyuibuilder.model.ComponentConditionProperty;
import com.amazonaws.services.amplifyuibuilder.model.ComponentPropertyBindingProperties;
import com.amazonaws.services.amplifyuibuilder.model.FormBindingElement;
import com.amazonaws.services.amplifyuibuilder.model.transform.ComponentPropertyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComponentProperty
implements Serializable,
Cloneable,
StructuredPojo {
    private ComponentPropertyBindingProperties bindingProperties;
    private Map<String, FormBindingElement> bindings;
    private ComponentPropertyBindingProperties collectionBindingProperties;
    private List<ComponentProperty> concat;
    private ComponentConditionProperty condition;
    private Boolean configured;
    private String defaultValue;
    private String event;
    private String importedValue;
    private String model;
    private String type;
    private String userAttribute;
    private String value;

    public void setBindingProperties(ComponentPropertyBindingProperties bindingProperties) {
        this.bindingProperties = bindingProperties;
    }

    public ComponentPropertyBindingProperties getBindingProperties() {
        return this.bindingProperties;
    }

    public ComponentProperty withBindingProperties(ComponentPropertyBindingProperties bindingProperties) {
        this.setBindingProperties(bindingProperties);
        return this;
    }

    public Map<String, FormBindingElement> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, FormBindingElement> bindings) {
        this.bindings = bindings;
    }

    public ComponentProperty withBindings(Map<String, FormBindingElement> bindings) {
        this.setBindings(bindings);
        return this;
    }

    public ComponentProperty addBindingsEntry(String key, FormBindingElement value) {
        if (null == this.bindings) {
            this.bindings = new HashMap<String, FormBindingElement>();
        }
        if (this.bindings.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.bindings.put(key, value);
        return this;
    }

    public ComponentProperty clearBindingsEntries() {
        this.bindings = null;
        return this;
    }

    public void setCollectionBindingProperties(ComponentPropertyBindingProperties collectionBindingProperties) {
        this.collectionBindingProperties = collectionBindingProperties;
    }

    public ComponentPropertyBindingProperties getCollectionBindingProperties() {
        return this.collectionBindingProperties;
    }

    public ComponentProperty withCollectionBindingProperties(ComponentPropertyBindingProperties collectionBindingProperties) {
        this.setCollectionBindingProperties(collectionBindingProperties);
        return this;
    }

    public List<ComponentProperty> getConcat() {
        return this.concat;
    }

    public void setConcat(Collection<ComponentProperty> concat) {
        if (concat == null) {
            this.concat = null;
            return;
        }
        this.concat = new ArrayList<ComponentProperty>(concat);
    }

    public ComponentProperty withConcat(ComponentProperty ... concat) {
        if (this.concat == null) {
            this.setConcat(new ArrayList<ComponentProperty>(concat.length));
        }
        for (ComponentProperty ele : concat) {
            this.concat.add(ele);
        }
        return this;
    }

    public ComponentProperty withConcat(Collection<ComponentProperty> concat) {
        this.setConcat(concat);
        return this;
    }

    public void setCondition(ComponentConditionProperty condition) {
        this.condition = condition;
    }

    public ComponentConditionProperty getCondition() {
        return this.condition;
    }

    public ComponentProperty withCondition(ComponentConditionProperty condition) {
        this.setCondition(condition);
        return this;
    }

    public void setConfigured(Boolean configured) {
        this.configured = configured;
    }

    public Boolean getConfigured() {
        return this.configured;
    }

    public ComponentProperty withConfigured(Boolean configured) {
        this.setConfigured(configured);
        return this;
    }

    public Boolean isConfigured() {
        return this.configured;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public ComponentProperty withDefaultValue(String defaultValue) {
        this.setDefaultValue(defaultValue);
        return this;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getEvent() {
        return this.event;
    }

    public ComponentProperty withEvent(String event) {
        this.setEvent(event);
        return this;
    }

    public void setImportedValue(String importedValue) {
        this.importedValue = importedValue;
    }

    public String getImportedValue() {
        return this.importedValue;
    }

    public ComponentProperty withImportedValue(String importedValue) {
        this.setImportedValue(importedValue);
        return this;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getModel() {
        return this.model;
    }

    public ComponentProperty withModel(String model) {
        this.setModel(model);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public ComponentProperty withType(String type) {
        this.setType(type);
        return this;
    }

    public void setUserAttribute(String userAttribute) {
        this.userAttribute = userAttribute;
    }

    public String getUserAttribute() {
        return this.userAttribute;
    }

    public ComponentProperty withUserAttribute(String userAttribute) {
        this.setUserAttribute(userAttribute);
        return this;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public ComponentProperty withValue(String value) {
        this.setValue(value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBindingProperties() != null) {
            sb.append("BindingProperties: ").append(this.getBindingProperties()).append(",");
        }
        if (this.getBindings() != null) {
            sb.append("Bindings: ").append(this.getBindings()).append(",");
        }
        if (this.getCollectionBindingProperties() != null) {
            sb.append("CollectionBindingProperties: ").append(this.getCollectionBindingProperties()).append(",");
        }
        if (this.getConcat() != null) {
            sb.append("Concat: ").append(this.getConcat()).append(",");
        }
        if (this.getCondition() != null) {
            sb.append("Condition: ").append(this.getCondition()).append(",");
        }
        if (this.getConfigured() != null) {
            sb.append("Configured: ").append(this.getConfigured()).append(",");
        }
        if (this.getDefaultValue() != null) {
            sb.append("DefaultValue: ").append(this.getDefaultValue()).append(",");
        }
        if (this.getEvent() != null) {
            sb.append("Event: ").append(this.getEvent()).append(",");
        }
        if (this.getImportedValue() != null) {
            sb.append("ImportedValue: ").append(this.getImportedValue()).append(",");
        }
        if (this.getModel() != null) {
            sb.append("Model: ").append(this.getModel()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getUserAttribute() != null) {
            sb.append("UserAttribute: ").append(this.getUserAttribute()).append(",");
        }
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentProperty)) {
            return false;
        }
        ComponentProperty other = (ComponentProperty)obj;
        if (other.getBindingProperties() == null ^ this.getBindingProperties() == null) {
            return false;
        }
        if (other.getBindingProperties() != null && !other.getBindingProperties().equals(this.getBindingProperties())) {
            return false;
        }
        if (other.getBindings() == null ^ this.getBindings() == null) {
            return false;
        }
        if (other.getBindings() != null && !other.getBindings().equals(this.getBindings())) {
            return false;
        }
        if (other.getCollectionBindingProperties() == null ^ this.getCollectionBindingProperties() == null) {
            return false;
        }
        if (other.getCollectionBindingProperties() != null && !other.getCollectionBindingProperties().equals(this.getCollectionBindingProperties())) {
            return false;
        }
        if (other.getConcat() == null ^ this.getConcat() == null) {
            return false;
        }
        if (other.getConcat() != null && !other.getConcat().equals(this.getConcat())) {
            return false;
        }
        if (other.getCondition() == null ^ this.getCondition() == null) {
            return false;
        }
        if (other.getCondition() != null && !other.getCondition().equals(this.getCondition())) {
            return false;
        }
        if (other.getConfigured() == null ^ this.getConfigured() == null) {
            return false;
        }
        if (other.getConfigured() != null && !other.getConfigured().equals(this.getConfigured())) {
            return false;
        }
        if (other.getDefaultValue() == null ^ this.getDefaultValue() == null) {
            return false;
        }
        if (other.getDefaultValue() != null && !other.getDefaultValue().equals(this.getDefaultValue())) {
            return false;
        }
        if (other.getEvent() == null ^ this.getEvent() == null) {
            return false;
        }
        if (other.getEvent() != null && !other.getEvent().equals(this.getEvent())) {
            return false;
        }
        if (other.getImportedValue() == null ^ this.getImportedValue() == null) {
            return false;
        }
        if (other.getImportedValue() != null && !other.getImportedValue().equals(this.getImportedValue())) {
            return false;
        }
        if (other.getModel() == null ^ this.getModel() == null) {
            return false;
        }
        if (other.getModel() != null && !other.getModel().equals(this.getModel())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getUserAttribute() == null ^ this.getUserAttribute() == null) {
            return false;
        }
        if (other.getUserAttribute() != null && !other.getUserAttribute().equals(this.getUserAttribute())) {
            return false;
        }
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        return other.getValue() == null || other.getValue().equals(this.getValue());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBindingProperties() == null ? 0 : this.getBindingProperties().hashCode());
        hashCode = 31 * hashCode + (this.getBindings() == null ? 0 : this.getBindings().hashCode());
        hashCode = 31 * hashCode + (this.getCollectionBindingProperties() == null ? 0 : this.getCollectionBindingProperties().hashCode());
        hashCode = 31 * hashCode + (this.getConcat() == null ? 0 : this.getConcat().hashCode());
        hashCode = 31 * hashCode + (this.getCondition() == null ? 0 : this.getCondition().hashCode());
        hashCode = 31 * hashCode + (this.getConfigured() == null ? 0 : this.getConfigured().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultValue() == null ? 0 : this.getDefaultValue().hashCode());
        hashCode = 31 * hashCode + (this.getEvent() == null ? 0 : this.getEvent().hashCode());
        hashCode = 31 * hashCode + (this.getImportedValue() == null ? 0 : this.getImportedValue().hashCode());
        hashCode = 31 * hashCode + (this.getModel() == null ? 0 : this.getModel().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getUserAttribute() == null ? 0 : this.getUserAttribute().hashCode());
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        return hashCode;
    }

    public ComponentProperty clone() {
        try {
            return (ComponentProperty)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComponentPropertyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

