/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplifyuibuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.amplifyuibuilder.model.ComponentBindingPropertiesValue;
import com.amazonaws.services.amplifyuibuilder.model.ComponentChild;
import com.amazonaws.services.amplifyuibuilder.model.ComponentDataConfiguration;
import com.amazonaws.services.amplifyuibuilder.model.ComponentProperty;
import com.amazonaws.services.amplifyuibuilder.model.ComponentVariant;
import com.amazonaws.services.amplifyuibuilder.model.transform.ComponentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Component
implements Serializable,
Cloneable,
StructuredPojo {
    private String appId;
    private Map<String, ComponentBindingPropertiesValue> bindingProperties;
    private List<ComponentChild> children;
    private Map<String, ComponentDataConfiguration> collectionProperties;
    private String componentType;
    private Date createdAt;
    private String environmentName;
    private String id;
    private Date modifiedAt;
    private String name;
    private Map<String, Map<String, String>> overrides;
    private Map<String, ComponentProperty> properties;
    private String sourceId;
    private Map<String, String> tags;
    private List<ComponentVariant> variants;

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public Component withAppId(String appId) {
        this.setAppId(appId);
        return this;
    }

    public Map<String, ComponentBindingPropertiesValue> getBindingProperties() {
        return this.bindingProperties;
    }

    public void setBindingProperties(Map<String, ComponentBindingPropertiesValue> bindingProperties) {
        this.bindingProperties = bindingProperties;
    }

    public Component withBindingProperties(Map<String, ComponentBindingPropertiesValue> bindingProperties) {
        this.setBindingProperties(bindingProperties);
        return this;
    }

    public Component addBindingPropertiesEntry(String key, ComponentBindingPropertiesValue value) {
        if (null == this.bindingProperties) {
            this.bindingProperties = new HashMap<String, ComponentBindingPropertiesValue>();
        }
        if (this.bindingProperties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.bindingProperties.put(key, value);
        return this;
    }

    public Component clearBindingPropertiesEntries() {
        this.bindingProperties = null;
        return this;
    }

    public List<ComponentChild> getChildren() {
        return this.children;
    }

    public void setChildren(Collection<ComponentChild> children) {
        if (children == null) {
            this.children = null;
            return;
        }
        this.children = new ArrayList<ComponentChild>(children);
    }

    public Component withChildren(ComponentChild ... children) {
        if (this.children == null) {
            this.setChildren(new ArrayList<ComponentChild>(children.length));
        }
        for (ComponentChild ele : children) {
            this.children.add(ele);
        }
        return this;
    }

    public Component withChildren(Collection<ComponentChild> children) {
        this.setChildren(children);
        return this;
    }

    public Map<String, ComponentDataConfiguration> getCollectionProperties() {
        return this.collectionProperties;
    }

    public void setCollectionProperties(Map<String, ComponentDataConfiguration> collectionProperties) {
        this.collectionProperties = collectionProperties;
    }

    public Component withCollectionProperties(Map<String, ComponentDataConfiguration> collectionProperties) {
        this.setCollectionProperties(collectionProperties);
        return this;
    }

    public Component addCollectionPropertiesEntry(String key, ComponentDataConfiguration value) {
        if (null == this.collectionProperties) {
            this.collectionProperties = new HashMap<String, ComponentDataConfiguration>();
        }
        if (this.collectionProperties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.collectionProperties.put(key, value);
        return this;
    }

    public Component clearCollectionPropertiesEntries() {
        this.collectionProperties = null;
        return this;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public Component withComponentType(String componentType) {
        this.setComponentType(componentType);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Component withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public Component withEnvironmentName(String environmentName) {
        this.setEnvironmentName(environmentName);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Component withId(String id) {
        this.setId(id);
        return this;
    }

    public void setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public Component withModifiedAt(Date modifiedAt) {
        this.setModifiedAt(modifiedAt);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Component withName(String name) {
        this.setName(name);
        return this;
    }

    public Map<String, Map<String, String>> getOverrides() {
        return this.overrides;
    }

    public void setOverrides(Map<String, Map<String, String>> overrides) {
        this.overrides = overrides;
    }

    public Component withOverrides(Map<String, Map<String, String>> overrides) {
        this.setOverrides(overrides);
        return this;
    }

    public Component addOverridesEntry(String key, Map<String, String> value) {
        if (null == this.overrides) {
            this.overrides = new HashMap<String, Map<String, String>>();
        }
        if (this.overrides.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.overrides.put(key, value);
        return this;
    }

    public Component clearOverridesEntries() {
        this.overrides = null;
        return this;
    }

    public Map<String, ComponentProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, ComponentProperty> properties) {
        this.properties = properties;
    }

    public Component withProperties(Map<String, ComponentProperty> properties) {
        this.setProperties(properties);
        return this;
    }

    public Component addPropertiesEntry(String key, ComponentProperty value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, ComponentProperty>();
        }
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.properties.put(key, value);
        return this;
    }

    public Component clearPropertiesEntries() {
        this.properties = null;
        return this;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public Component withSourceId(String sourceId) {
        this.setSourceId(sourceId);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Component withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Component addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Component clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public List<ComponentVariant> getVariants() {
        return this.variants;
    }

    public void setVariants(Collection<ComponentVariant> variants) {
        if (variants == null) {
            this.variants = null;
            return;
        }
        this.variants = new ArrayList<ComponentVariant>(variants);
    }

    public Component withVariants(ComponentVariant ... variants) {
        if (this.variants == null) {
            this.setVariants(new ArrayList<ComponentVariant>(variants.length));
        }
        for (ComponentVariant ele : variants) {
            this.variants.add(ele);
        }
        return this;
    }

    public Component withVariants(Collection<ComponentVariant> variants) {
        this.setVariants(variants);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppId() != null) {
            sb.append("AppId: ").append(this.getAppId()).append(",");
        }
        if (this.getBindingProperties() != null) {
            sb.append("BindingProperties: ").append(this.getBindingProperties()).append(",");
        }
        if (this.getChildren() != null) {
            sb.append("Children: ").append(this.getChildren()).append(",");
        }
        if (this.getCollectionProperties() != null) {
            sb.append("CollectionProperties: ").append(this.getCollectionProperties()).append(",");
        }
        if (this.getComponentType() != null) {
            sb.append("ComponentType: ").append(this.getComponentType()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getEnvironmentName() != null) {
            sb.append("EnvironmentName: ").append(this.getEnvironmentName()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getModifiedAt() != null) {
            sb.append("ModifiedAt: ").append(this.getModifiedAt()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOverrides() != null) {
            sb.append("Overrides: ").append(this.getOverrides()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties()).append(",");
        }
        if (this.getSourceId() != null) {
            sb.append("SourceId: ").append(this.getSourceId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVariants() != null) {
            sb.append("Variants: ").append(this.getVariants());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Component)) {
            return false;
        }
        Component other = (Component)obj;
        if (other.getAppId() == null ^ this.getAppId() == null) {
            return false;
        }
        if (other.getAppId() != null && !other.getAppId().equals(this.getAppId())) {
            return false;
        }
        if (other.getBindingProperties() == null ^ this.getBindingProperties() == null) {
            return false;
        }
        if (other.getBindingProperties() != null && !other.getBindingProperties().equals(this.getBindingProperties())) {
            return false;
        }
        if (other.getChildren() == null ^ this.getChildren() == null) {
            return false;
        }
        if (other.getChildren() != null && !other.getChildren().equals(this.getChildren())) {
            return false;
        }
        if (other.getCollectionProperties() == null ^ this.getCollectionProperties() == null) {
            return false;
        }
        if (other.getCollectionProperties() != null && !other.getCollectionProperties().equals(this.getCollectionProperties())) {
            return false;
        }
        if (other.getComponentType() == null ^ this.getComponentType() == null) {
            return false;
        }
        if (other.getComponentType() != null && !other.getComponentType().equals(this.getComponentType())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getEnvironmentName() == null ^ this.getEnvironmentName() == null) {
            return false;
        }
        if (other.getEnvironmentName() != null && !other.getEnvironmentName().equals(this.getEnvironmentName())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getModifiedAt() == null ^ this.getModifiedAt() == null) {
            return false;
        }
        if (other.getModifiedAt() != null && !other.getModifiedAt().equals(this.getModifiedAt())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOverrides() == null ^ this.getOverrides() == null) {
            return false;
        }
        if (other.getOverrides() != null && !other.getOverrides().equals(this.getOverrides())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        if (other.getProperties() != null && !other.getProperties().equals(this.getProperties())) {
            return false;
        }
        if (other.getSourceId() == null ^ this.getSourceId() == null) {
            return false;
        }
        if (other.getSourceId() != null && !other.getSourceId().equals(this.getSourceId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVariants() == null ^ this.getVariants() == null) {
            return false;
        }
        return other.getVariants() == null || other.getVariants().equals(this.getVariants());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppId() == null ? 0 : this.getAppId().hashCode());
        hashCode = 31 * hashCode + (this.getBindingProperties() == null ? 0 : this.getBindingProperties().hashCode());
        hashCode = 31 * hashCode + (this.getChildren() == null ? 0 : this.getChildren().hashCode());
        hashCode = 31 * hashCode + (this.getCollectionProperties() == null ? 0 : this.getCollectionProperties().hashCode());
        hashCode = 31 * hashCode + (this.getComponentType() == null ? 0 : this.getComponentType().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentName() == null ? 0 : this.getEnvironmentName().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getModifiedAt() == null ? 0 : this.getModifiedAt().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOverrides() == null ? 0 : this.getOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        hashCode = 31 * hashCode + (this.getSourceId() == null ? 0 : this.getSourceId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVariants() == null ? 0 : this.getVariants().hashCode());
        return hashCode;
    }

    public Component clone() {
        try {
            return (Component)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComponentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

