/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplifyuibuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.amplifyuibuilder.model.ComponentEvent;
import com.amazonaws.services.amplifyuibuilder.model.ComponentProperty;
import com.amazonaws.services.amplifyuibuilder.model.transform.ComponentChildMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComponentChild
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ComponentChild> children;
    private String componentType;
    private Map<String, ComponentEvent> events;
    private String name;
    private Map<String, ComponentProperty> properties;

    public List<ComponentChild> getChildren() {
        return this.children;
    }

    public void setChildren(Collection<ComponentChild> children) {
        if (children == null) {
            this.children = null;
            return;
        }
        this.children = new ArrayList<ComponentChild>(children);
    }

    public ComponentChild withChildren(ComponentChild ... children) {
        if (this.children == null) {
            this.setChildren(new ArrayList<ComponentChild>(children.length));
        }
        for (ComponentChild ele : children) {
            this.children.add(ele);
        }
        return this;
    }

    public ComponentChild withChildren(Collection<ComponentChild> children) {
        this.setChildren(children);
        return this;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public ComponentChild withComponentType(String componentType) {
        this.setComponentType(componentType);
        return this;
    }

    public Map<String, ComponentEvent> getEvents() {
        return this.events;
    }

    public void setEvents(Map<String, ComponentEvent> events) {
        this.events = events;
    }

    public ComponentChild withEvents(Map<String, ComponentEvent> events) {
        this.setEvents(events);
        return this;
    }

    public ComponentChild addEventsEntry(String key, ComponentEvent value) {
        if (null == this.events) {
            this.events = new HashMap<String, ComponentEvent>();
        }
        if (this.events.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.events.put(key, value);
        return this;
    }

    public ComponentChild clearEventsEntries() {
        this.events = null;
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ComponentChild withName(String name) {
        this.setName(name);
        return this;
    }

    public Map<String, ComponentProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, ComponentProperty> properties) {
        this.properties = properties;
    }

    public ComponentChild withProperties(Map<String, ComponentProperty> properties) {
        this.setProperties(properties);
        return this;
    }

    public ComponentChild addPropertiesEntry(String key, ComponentProperty value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, ComponentProperty>();
        }
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.properties.put(key, value);
        return this;
    }

    public ComponentChild clearPropertiesEntries() {
        this.properties = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChildren() != null) {
            sb.append("Children: ").append(this.getChildren()).append(",");
        }
        if (this.getComponentType() != null) {
            sb.append("ComponentType: ").append(this.getComponentType()).append(",");
        }
        if (this.getEvents() != null) {
            sb.append("Events: ").append(this.getEvents()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentChild)) {
            return false;
        }
        ComponentChild other = (ComponentChild)obj;
        if (other.getChildren() == null ^ this.getChildren() == null) {
            return false;
        }
        if (other.getChildren() != null && !other.getChildren().equals(this.getChildren())) {
            return false;
        }
        if (other.getComponentType() == null ^ this.getComponentType() == null) {
            return false;
        }
        if (other.getComponentType() != null && !other.getComponentType().equals(this.getComponentType())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        if (other.getEvents() != null && !other.getEvents().equals(this.getEvents())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        return other.getProperties() == null || other.getProperties().equals(this.getProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChildren() == null ? 0 : this.getChildren().hashCode());
        hashCode = 31 * hashCode + (this.getComponentType() == null ? 0 : this.getComponentType().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        return hashCode;
    }

    public ComponentChild clone() {
        try {
            return (ComponentChild)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComponentChildMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

