/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.amplifyuibuilder.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Represents the data binding configuration for a specific property using data stored in Amazon Web Services. For
 * Amazon Web Services connected properties, you can bind a property to data stored in an Amplify DataStore model.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/FormInputBindingPropertiesValueProperties"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class FormInputBindingPropertiesValueProperties implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * An Amplify DataStore model.
     * </p>
     */
    private String model;

    /**
     * <p>
     * An Amplify DataStore model.
     * </p>
     * 
     * @param model
     *        An Amplify DataStore model.
     */

    public void setModel(String model) {
        this.model = model;
    }

    /**
     * <p>
     * An Amplify DataStore model.
     * </p>
     * 
     * @return An Amplify DataStore model.
     */

    public String getModel() {
        return this.model;
    }

    /**
     * <p>
     * An Amplify DataStore model.
     * </p>
     * 
     * @param model
     *        An Amplify DataStore model.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FormInputBindingPropertiesValueProperties withModel(String model) {
        setModel(model);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getModel() != null)
            sb.append("Model: ").append(getModel());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof FormInputBindingPropertiesValueProperties == false)
            return false;
        FormInputBindingPropertiesValueProperties other = (FormInputBindingPropertiesValueProperties) obj;
        if (other.getModel() == null ^ this.getModel() == null)
            return false;
        if (other.getModel() != null && other.getModel().equals(this.getModel()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getModel() == null) ? 0 : getModel().hashCode());
        return hashCode;
    }

    @Override
    public FormInputBindingPropertiesValueProperties clone() {
        try {
            return (FormInputBindingPropertiesValueProperties) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.amplifyuibuilder.model.transform.FormInputBindingPropertiesValuePropertiesMarshaller.getInstance().marshall(this,
                protocolMarshaller);
    }
}
