/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.apigateway.model.Integration;
import com.amazonaws.services.apigateway.model.IntegrationResponse;
import com.amazonaws.services.apigateway.model.transform.IntegrationResponseJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;
import java.util.Map;

public class IntegrationJsonMarshaller {
    private static IntegrationJsonMarshaller instance;

    public void marshall(Integration integration, JSONWriter jsonWriter) {
        if (integration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, IntegrationResponse> integrationResponsesMap;
            List<String> cacheKeyParametersList;
            Map<String, String> requestTemplatesMap;
            Map<String, String> requestParametersMap;
            jsonWriter.object();
            if (integration.getType() != null) {
                jsonWriter.key("type").value((Object)integration.getType());
            }
            if (integration.getHttpMethod() != null) {
                jsonWriter.key("httpMethod").value((Object)integration.getHttpMethod());
            }
            if (integration.getUri() != null) {
                jsonWriter.key("uri").value((Object)integration.getUri());
            }
            if (integration.getCredentials() != null) {
                jsonWriter.key("credentials").value((Object)integration.getCredentials());
            }
            if ((requestParametersMap = integration.getRequestParameters()) != null) {
                jsonWriter.key("requestParameters");
                jsonWriter.object();
                for (Map.Entry<String, String> requestParametersMapValue : requestParametersMap.entrySet()) {
                    if (requestParametersMapValue.getValue() == null) continue;
                    jsonWriter.key(requestParametersMapValue.getKey());
                    jsonWriter.value((Object)requestParametersMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if ((requestTemplatesMap = integration.getRequestTemplates()) != null) {
                jsonWriter.key("requestTemplates");
                jsonWriter.object();
                for (Map.Entry<String, String> requestTemplatesMapValue : requestTemplatesMap.entrySet()) {
                    if (requestTemplatesMapValue.getValue() == null) continue;
                    jsonWriter.key(requestTemplatesMapValue.getKey());
                    jsonWriter.value((Object)requestTemplatesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (integration.getCacheNamespace() != null) {
                jsonWriter.key("cacheNamespace").value((Object)integration.getCacheNamespace());
            }
            if ((cacheKeyParametersList = integration.getCacheKeyParameters()) != null) {
                jsonWriter.key("cacheKeyParameters");
                jsonWriter.array();
                for (String cacheKeyParametersListValue : cacheKeyParametersList) {
                    if (cacheKeyParametersListValue == null) continue;
                    jsonWriter.value((Object)cacheKeyParametersListValue);
                }
                jsonWriter.endArray();
            }
            if ((integrationResponsesMap = integration.getIntegrationResponses()) != null) {
                jsonWriter.key("integrationResponses");
                jsonWriter.object();
                for (Map.Entry<String, IntegrationResponse> integrationResponsesMapValue : integrationResponsesMap.entrySet()) {
                    if (integrationResponsesMapValue.getValue() == null) continue;
                    jsonWriter.key(integrationResponsesMapValue.getKey());
                    IntegrationResponseJsonMarshaller.getInstance().marshall(integrationResponsesMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static IntegrationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new IntegrationJsonMarshaller();
        }
        return instance;
    }
}

