/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.apigateway.model.ApiKey;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.List;

public class ApiKeyJsonMarshaller {
    private static ApiKeyJsonMarshaller instance;

    public void marshall(ApiKey apiKey, StructuredJsonGenerator jsonGenerator) {
        if (apiKey == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> stageKeysList;
            jsonGenerator.writeStartObject();
            if (apiKey.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(apiKey.getId());
            }
            if (apiKey.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(apiKey.getName());
            }
            if (apiKey.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(apiKey.getDescription());
            }
            if (apiKey.getEnabled() != null) {
                jsonGenerator.writeFieldName("enabled").writeValue(apiKey.getEnabled().booleanValue());
            }
            if ((stageKeysList = apiKey.getStageKeys()) != null) {
                jsonGenerator.writeFieldName("stageKeys");
                jsonGenerator.writeStartArray();
                for (String stageKeysListValue : stageKeysList) {
                    if (stageKeysListValue == null) continue;
                    jsonGenerator.writeValue(stageKeysListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (apiKey.getCreatedDate() != null) {
                jsonGenerator.writeFieldName("createdDate").writeValue(apiKey.getCreatedDate());
            }
            if (apiKey.getLastUpdatedDate() != null) {
                jsonGenerator.writeFieldName("lastUpdatedDate").writeValue(apiKey.getLastUpdatedDate());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ApiKeyJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ApiKeyJsonMarshaller();
        }
        return instance;
    }
}

