/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetIntegrationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetIntegrationRequestMarshaller
implements Marshaller<Request<GetIntegrationRequest>, GetIntegrationRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public GetIntegrationRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetIntegrationRequest> marshall(GetIntegrationRequest getIntegrationRequest) {
        if (getIntegrationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getIntegrationRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getIntegrationRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getIntegrationRequest.getRestApiId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{resource_id}", getIntegrationRequest.getResourceId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getIntegrationRequest.getResourceId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{http_method}", getIntegrationRequest.getHttpMethod() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getIntegrationRequest.getHttpMethod()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

