/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.apigateway.model.ContentHandlingStrategy;
import com.amazonaws.services.apigateway.model.IntegrationType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PutIntegrationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String restApiId;
    private String resourceId;
    private String httpMethod;
    private String type;
    private String integrationHttpMethod;
    private String uri;
    private String credentials;
    private Map<String, String> requestParameters;
    private Map<String, String> requestTemplates;
    private String passthroughBehavior;
    private String cacheNamespace;
    private List<String> cacheKeyParameters;
    private String contentHandling;

    public void setRestApiId(String restApiId) {
        this.restApiId = restApiId;
    }

    public String getRestApiId() {
        return this.restApiId;
    }

    public PutIntegrationRequest withRestApiId(String restApiId) {
        this.setRestApiId(restApiId);
        return this;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public PutIntegrationRequest withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public PutIntegrationRequest withHttpMethod(String httpMethod) {
        this.setHttpMethod(httpMethod);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public PutIntegrationRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public void setType(IntegrationType type) {
        this.withType(type);
    }

    public PutIntegrationRequest withType(IntegrationType type) {
        this.type = type.toString();
        return this;
    }

    public void setIntegrationHttpMethod(String integrationHttpMethod) {
        this.integrationHttpMethod = integrationHttpMethod;
    }

    public String getIntegrationHttpMethod() {
        return this.integrationHttpMethod;
    }

    public PutIntegrationRequest withIntegrationHttpMethod(String integrationHttpMethod) {
        this.setIntegrationHttpMethod(integrationHttpMethod);
        return this;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public PutIntegrationRequest withUri(String uri) {
        this.setUri(uri);
        return this;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public PutIntegrationRequest withCredentials(String credentials) {
        this.setCredentials(credentials);
        return this;
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public void setRequestParameters(Map<String, String> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public PutIntegrationRequest withRequestParameters(Map<String, String> requestParameters) {
        this.setRequestParameters(requestParameters);
        return this;
    }

    public PutIntegrationRequest addRequestParametersEntry(String key, String value) {
        if (null == this.requestParameters) {
            this.requestParameters = new HashMap<String, String>();
        }
        if (this.requestParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.requestParameters.put(key, value);
        return this;
    }

    public PutIntegrationRequest clearRequestParametersEntries() {
        this.requestParameters = null;
        return this;
    }

    public Map<String, String> getRequestTemplates() {
        return this.requestTemplates;
    }

    public void setRequestTemplates(Map<String, String> requestTemplates) {
        this.requestTemplates = requestTemplates;
    }

    public PutIntegrationRequest withRequestTemplates(Map<String, String> requestTemplates) {
        this.setRequestTemplates(requestTemplates);
        return this;
    }

    public PutIntegrationRequest addRequestTemplatesEntry(String key, String value) {
        if (null == this.requestTemplates) {
            this.requestTemplates = new HashMap<String, String>();
        }
        if (this.requestTemplates.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.requestTemplates.put(key, value);
        return this;
    }

    public PutIntegrationRequest clearRequestTemplatesEntries() {
        this.requestTemplates = null;
        return this;
    }

    public void setPassthroughBehavior(String passthroughBehavior) {
        this.passthroughBehavior = passthroughBehavior;
    }

    public String getPassthroughBehavior() {
        return this.passthroughBehavior;
    }

    public PutIntegrationRequest withPassthroughBehavior(String passthroughBehavior) {
        this.setPassthroughBehavior(passthroughBehavior);
        return this;
    }

    public void setCacheNamespace(String cacheNamespace) {
        this.cacheNamespace = cacheNamespace;
    }

    public String getCacheNamespace() {
        return this.cacheNamespace;
    }

    public PutIntegrationRequest withCacheNamespace(String cacheNamespace) {
        this.setCacheNamespace(cacheNamespace);
        return this;
    }

    public List<String> getCacheKeyParameters() {
        return this.cacheKeyParameters;
    }

    public void setCacheKeyParameters(Collection<String> cacheKeyParameters) {
        if (cacheKeyParameters == null) {
            this.cacheKeyParameters = null;
            return;
        }
        this.cacheKeyParameters = new ArrayList<String>(cacheKeyParameters);
    }

    public PutIntegrationRequest withCacheKeyParameters(String ... cacheKeyParameters) {
        if (this.cacheKeyParameters == null) {
            this.setCacheKeyParameters(new ArrayList<String>(cacheKeyParameters.length));
        }
        for (String ele : cacheKeyParameters) {
            this.cacheKeyParameters.add(ele);
        }
        return this;
    }

    public PutIntegrationRequest withCacheKeyParameters(Collection<String> cacheKeyParameters) {
        this.setCacheKeyParameters(cacheKeyParameters);
        return this;
    }

    public void setContentHandling(String contentHandling) {
        this.contentHandling = contentHandling;
    }

    public String getContentHandling() {
        return this.contentHandling;
    }

    public PutIntegrationRequest withContentHandling(String contentHandling) {
        this.setContentHandling(contentHandling);
        return this;
    }

    public void setContentHandling(ContentHandlingStrategy contentHandling) {
        this.withContentHandling(contentHandling);
    }

    public PutIntegrationRequest withContentHandling(ContentHandlingStrategy contentHandling) {
        this.contentHandling = contentHandling.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRestApiId() != null) {
            sb.append("RestApiId: ").append(this.getRestApiId()).append(",");
        }
        if (this.getResourceId() != null) {
            sb.append("ResourceId: ").append(this.getResourceId()).append(",");
        }
        if (this.getHttpMethod() != null) {
            sb.append("HttpMethod: ").append(this.getHttpMethod()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getIntegrationHttpMethod() != null) {
            sb.append("IntegrationHttpMethod: ").append(this.getIntegrationHttpMethod()).append(",");
        }
        if (this.getUri() != null) {
            sb.append("Uri: ").append(this.getUri()).append(",");
        }
        if (this.getCredentials() != null) {
            sb.append("Credentials: ").append(this.getCredentials()).append(",");
        }
        if (this.getRequestParameters() != null) {
            sb.append("RequestParameters: ").append(this.getRequestParameters()).append(",");
        }
        if (this.getRequestTemplates() != null) {
            sb.append("RequestTemplates: ").append(this.getRequestTemplates()).append(",");
        }
        if (this.getPassthroughBehavior() != null) {
            sb.append("PassthroughBehavior: ").append(this.getPassthroughBehavior()).append(",");
        }
        if (this.getCacheNamespace() != null) {
            sb.append("CacheNamespace: ").append(this.getCacheNamespace()).append(",");
        }
        if (this.getCacheKeyParameters() != null) {
            sb.append("CacheKeyParameters: ").append(this.getCacheKeyParameters()).append(",");
        }
        if (this.getContentHandling() != null) {
            sb.append("ContentHandling: ").append(this.getContentHandling());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntegrationRequest)) {
            return false;
        }
        PutIntegrationRequest other = (PutIntegrationRequest)obj;
        if (other.getRestApiId() == null ^ this.getRestApiId() == null) {
            return false;
        }
        if (other.getRestApiId() != null && !other.getRestApiId().equals(this.getRestApiId())) {
            return false;
        }
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getHttpMethod() == null ^ this.getHttpMethod() == null) {
            return false;
        }
        if (other.getHttpMethod() != null && !other.getHttpMethod().equals(this.getHttpMethod())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getIntegrationHttpMethod() == null ^ this.getIntegrationHttpMethod() == null) {
            return false;
        }
        if (other.getIntegrationHttpMethod() != null && !other.getIntegrationHttpMethod().equals(this.getIntegrationHttpMethod())) {
            return false;
        }
        if (other.getUri() == null ^ this.getUri() == null) {
            return false;
        }
        if (other.getUri() != null && !other.getUri().equals(this.getUri())) {
            return false;
        }
        if (other.getCredentials() == null ^ this.getCredentials() == null) {
            return false;
        }
        if (other.getCredentials() != null && !other.getCredentials().equals(this.getCredentials())) {
            return false;
        }
        if (other.getRequestParameters() == null ^ this.getRequestParameters() == null) {
            return false;
        }
        if (other.getRequestParameters() != null && !other.getRequestParameters().equals(this.getRequestParameters())) {
            return false;
        }
        if (other.getRequestTemplates() == null ^ this.getRequestTemplates() == null) {
            return false;
        }
        if (other.getRequestTemplates() != null && !other.getRequestTemplates().equals(this.getRequestTemplates())) {
            return false;
        }
        if (other.getPassthroughBehavior() == null ^ this.getPassthroughBehavior() == null) {
            return false;
        }
        if (other.getPassthroughBehavior() != null && !other.getPassthroughBehavior().equals(this.getPassthroughBehavior())) {
            return false;
        }
        if (other.getCacheNamespace() == null ^ this.getCacheNamespace() == null) {
            return false;
        }
        if (other.getCacheNamespace() != null && !other.getCacheNamespace().equals(this.getCacheNamespace())) {
            return false;
        }
        if (other.getCacheKeyParameters() == null ^ this.getCacheKeyParameters() == null) {
            return false;
        }
        if (other.getCacheKeyParameters() != null && !other.getCacheKeyParameters().equals(this.getCacheKeyParameters())) {
            return false;
        }
        if (other.getContentHandling() == null ^ this.getContentHandling() == null) {
            return false;
        }
        return other.getContentHandling() == null || other.getContentHandling().equals(this.getContentHandling());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRestApiId() == null ? 0 : this.getRestApiId().hashCode());
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getHttpMethod() == null ? 0 : this.getHttpMethod().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getIntegrationHttpMethod() == null ? 0 : this.getIntegrationHttpMethod().hashCode());
        hashCode = 31 * hashCode + (this.getUri() == null ? 0 : this.getUri().hashCode());
        hashCode = 31 * hashCode + (this.getCredentials() == null ? 0 : this.getCredentials().hashCode());
        hashCode = 31 * hashCode + (this.getRequestParameters() == null ? 0 : this.getRequestParameters().hashCode());
        hashCode = 31 * hashCode + (this.getRequestTemplates() == null ? 0 : this.getRequestTemplates().hashCode());
        hashCode = 31 * hashCode + (this.getPassthroughBehavior() == null ? 0 : this.getPassthroughBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNamespace() == null ? 0 : this.getCacheNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getCacheKeyParameters() == null ? 0 : this.getCacheKeyParameters().hashCode());
        hashCode = 31 * hashCode + (this.getContentHandling() == null ? 0 : this.getContentHandling().hashCode());
        return hashCode;
    }

    public PutIntegrationRequest clone() {
        return (PutIntegrationRequest)super.clone();
    }
}

