/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apigateway.model.QuotaPeriodType;
import com.amazonaws.services.apigateway.model.transform.QuotaSettingsMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;

public class QuotaSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer limit;
    private Integer offset;
    private String period;

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public QuotaSettings withLimit(Integer limit) {
        this.setLimit(limit);
        return this;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public QuotaSettings withOffset(Integer offset) {
        this.setOffset(offset);
        return this;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    @JsonProperty(value="period")
    public String getPeriod() {
        return this.period;
    }

    public QuotaSettings withPeriod(String period) {
        this.setPeriod(period);
        return this;
    }

    @JsonIgnore
    public void setPeriod(QuotaPeriodType period) {
        this.withPeriod(period);
    }

    public QuotaSettings withPeriod(QuotaPeriodType period) {
        this.period = period.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLimit() != null) {
            sb.append("Limit: ").append(this.getLimit()).append(",");
        }
        if (this.getOffset() != null) {
            sb.append("Offset: ").append(this.getOffset()).append(",");
        }
        if (this.getPeriod() != null) {
            sb.append("Period: ").append(this.getPeriod());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuotaSettings)) {
            return false;
        }
        QuotaSettings other = (QuotaSettings)obj;
        if (other.getLimit() == null ^ this.getLimit() == null) {
            return false;
        }
        if (other.getLimit() != null && !other.getLimit().equals(this.getLimit())) {
            return false;
        }
        if (other.getOffset() == null ^ this.getOffset() == null) {
            return false;
        }
        if (other.getOffset() != null && !other.getOffset().equals(this.getOffset())) {
            return false;
        }
        if (other.getPeriod() == null ^ this.getPeriod() == null) {
            return false;
        }
        return other.getPeriod() == null || other.getPeriod().equals(this.getPeriod());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLimit() == null ? 0 : this.getLimit().hashCode());
        hashCode = 31 * hashCode + (this.getOffset() == null ? 0 : this.getOffset().hashCode());
        hashCode = 31 * hashCode + (this.getPeriod() == null ? 0 : this.getPeriod().hashCode());
        return hashCode;
    }

    public QuotaSettings clone() {
        try {
            return (QuotaSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QuotaSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

