/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.CreateUsagePlanKeyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateUsagePlanKeyRequestMarshaller
implements Marshaller<Request<CreateUsagePlanKeyRequest>, CreateUsagePlanKeyRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateUsagePlanKeyRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateUsagePlanKeyRequest> marshall(CreateUsagePlanKeyRequest createUsagePlanKeyRequest) {
        if (createUsagePlanKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createUsagePlanKeyRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/usageplans/{usageplanId}/keys";
        uriResourcePath = uriResourcePath.replace("{usageplanId}", createUsagePlanKeyRequest.getUsagePlanId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)createUsagePlanKeyRequest.getUsagePlanId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createUsagePlanKeyRequest.getKeyId() != null) {
                jsonGenerator.writeFieldName("keyId").writeValue(createUsagePlanKeyRequest.getKeyId());
            }
            if (createUsagePlanKeyRequest.getKeyType() != null) {
                jsonGenerator.writeFieldName("keyType").writeValue(createUsagePlanKeyRequest.getKeyType());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

