/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.apigateway.model.IntegrationResponse;
import com.amazonaws.services.apigateway.model.IntegrationType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateIntegrationResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String type;
    private String httpMethod;
    private String uri;
    private String credentials;
    private Map<String, String> requestParameters;
    private Map<String, String> requestTemplates;
    private String passthroughBehavior;
    private String cacheNamespace;
    private List<String> cacheKeyParameters;
    private Map<String, IntegrationResponse> integrationResponses;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public UpdateIntegrationResult withType(String type) {
        this.setType(type);
        return this;
    }

    public void setType(IntegrationType type) {
        this.type = type.toString();
    }

    public UpdateIntegrationResult withType(IntegrationType type) {
        this.setType(type);
        return this;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public UpdateIntegrationResult withHttpMethod(String httpMethod) {
        this.setHttpMethod(httpMethod);
        return this;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public UpdateIntegrationResult withUri(String uri) {
        this.setUri(uri);
        return this;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public UpdateIntegrationResult withCredentials(String credentials) {
        this.setCredentials(credentials);
        return this;
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public void setRequestParameters(Map<String, String> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public UpdateIntegrationResult withRequestParameters(Map<String, String> requestParameters) {
        this.setRequestParameters(requestParameters);
        return this;
    }

    public UpdateIntegrationResult addRequestParametersEntry(String key, String value) {
        if (null == this.requestParameters) {
            this.requestParameters = new HashMap<String, String>();
        }
        if (this.requestParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.requestParameters.put(key, value);
        return this;
    }

    public UpdateIntegrationResult clearRequestParametersEntries() {
        this.requestParameters = null;
        return this;
    }

    public Map<String, String> getRequestTemplates() {
        return this.requestTemplates;
    }

    public void setRequestTemplates(Map<String, String> requestTemplates) {
        this.requestTemplates = requestTemplates;
    }

    public UpdateIntegrationResult withRequestTemplates(Map<String, String> requestTemplates) {
        this.setRequestTemplates(requestTemplates);
        return this;
    }

    public UpdateIntegrationResult addRequestTemplatesEntry(String key, String value) {
        if (null == this.requestTemplates) {
            this.requestTemplates = new HashMap<String, String>();
        }
        if (this.requestTemplates.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.requestTemplates.put(key, value);
        return this;
    }

    public UpdateIntegrationResult clearRequestTemplatesEntries() {
        this.requestTemplates = null;
        return this;
    }

    public void setPassthroughBehavior(String passthroughBehavior) {
        this.passthroughBehavior = passthroughBehavior;
    }

    public String getPassthroughBehavior() {
        return this.passthroughBehavior;
    }

    public UpdateIntegrationResult withPassthroughBehavior(String passthroughBehavior) {
        this.setPassthroughBehavior(passthroughBehavior);
        return this;
    }

    public void setCacheNamespace(String cacheNamespace) {
        this.cacheNamespace = cacheNamespace;
    }

    public String getCacheNamespace() {
        return this.cacheNamespace;
    }

    public UpdateIntegrationResult withCacheNamespace(String cacheNamespace) {
        this.setCacheNamespace(cacheNamespace);
        return this;
    }

    public List<String> getCacheKeyParameters() {
        return this.cacheKeyParameters;
    }

    public void setCacheKeyParameters(Collection<String> cacheKeyParameters) {
        if (cacheKeyParameters == null) {
            this.cacheKeyParameters = null;
            return;
        }
        this.cacheKeyParameters = new ArrayList<String>(cacheKeyParameters);
    }

    public UpdateIntegrationResult withCacheKeyParameters(String ... cacheKeyParameters) {
        if (this.cacheKeyParameters == null) {
            this.setCacheKeyParameters(new ArrayList<String>(cacheKeyParameters.length));
        }
        for (String ele : cacheKeyParameters) {
            this.cacheKeyParameters.add(ele);
        }
        return this;
    }

    public UpdateIntegrationResult withCacheKeyParameters(Collection<String> cacheKeyParameters) {
        this.setCacheKeyParameters(cacheKeyParameters);
        return this;
    }

    public Map<String, IntegrationResponse> getIntegrationResponses() {
        return this.integrationResponses;
    }

    public void setIntegrationResponses(Map<String, IntegrationResponse> integrationResponses) {
        this.integrationResponses = integrationResponses;
    }

    public UpdateIntegrationResult withIntegrationResponses(Map<String, IntegrationResponse> integrationResponses) {
        this.setIntegrationResponses(integrationResponses);
        return this;
    }

    public UpdateIntegrationResult addIntegrationResponsesEntry(String key, IntegrationResponse value) {
        if (null == this.integrationResponses) {
            this.integrationResponses = new HashMap<String, IntegrationResponse>();
        }
        if (this.integrationResponses.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.integrationResponses.put(key, value);
        return this;
    }

    public UpdateIntegrationResult clearIntegrationResponsesEntries() {
        this.integrationResponses = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: " + this.getType() + ",");
        }
        if (this.getHttpMethod() != null) {
            sb.append("HttpMethod: " + this.getHttpMethod() + ",");
        }
        if (this.getUri() != null) {
            sb.append("Uri: " + this.getUri() + ",");
        }
        if (this.getCredentials() != null) {
            sb.append("Credentials: " + this.getCredentials() + ",");
        }
        if (this.getRequestParameters() != null) {
            sb.append("RequestParameters: " + this.getRequestParameters() + ",");
        }
        if (this.getRequestTemplates() != null) {
            sb.append("RequestTemplates: " + this.getRequestTemplates() + ",");
        }
        if (this.getPassthroughBehavior() != null) {
            sb.append("PassthroughBehavior: " + this.getPassthroughBehavior() + ",");
        }
        if (this.getCacheNamespace() != null) {
            sb.append("CacheNamespace: " + this.getCacheNamespace() + ",");
        }
        if (this.getCacheKeyParameters() != null) {
            sb.append("CacheKeyParameters: " + this.getCacheKeyParameters() + ",");
        }
        if (this.getIntegrationResponses() != null) {
            sb.append("IntegrationResponses: " + this.getIntegrationResponses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIntegrationResult)) {
            return false;
        }
        UpdateIntegrationResult other = (UpdateIntegrationResult)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getHttpMethod() == null ^ this.getHttpMethod() == null) {
            return false;
        }
        if (other.getHttpMethod() != null && !other.getHttpMethod().equals(this.getHttpMethod())) {
            return false;
        }
        if (other.getUri() == null ^ this.getUri() == null) {
            return false;
        }
        if (other.getUri() != null && !other.getUri().equals(this.getUri())) {
            return false;
        }
        if (other.getCredentials() == null ^ this.getCredentials() == null) {
            return false;
        }
        if (other.getCredentials() != null && !other.getCredentials().equals(this.getCredentials())) {
            return false;
        }
        if (other.getRequestParameters() == null ^ this.getRequestParameters() == null) {
            return false;
        }
        if (other.getRequestParameters() != null && !other.getRequestParameters().equals(this.getRequestParameters())) {
            return false;
        }
        if (other.getRequestTemplates() == null ^ this.getRequestTemplates() == null) {
            return false;
        }
        if (other.getRequestTemplates() != null && !other.getRequestTemplates().equals(this.getRequestTemplates())) {
            return false;
        }
        if (other.getPassthroughBehavior() == null ^ this.getPassthroughBehavior() == null) {
            return false;
        }
        if (other.getPassthroughBehavior() != null && !other.getPassthroughBehavior().equals(this.getPassthroughBehavior())) {
            return false;
        }
        if (other.getCacheNamespace() == null ^ this.getCacheNamespace() == null) {
            return false;
        }
        if (other.getCacheNamespace() != null && !other.getCacheNamespace().equals(this.getCacheNamespace())) {
            return false;
        }
        if (other.getCacheKeyParameters() == null ^ this.getCacheKeyParameters() == null) {
            return false;
        }
        if (other.getCacheKeyParameters() != null && !other.getCacheKeyParameters().equals(this.getCacheKeyParameters())) {
            return false;
        }
        if (other.getIntegrationResponses() == null ^ this.getIntegrationResponses() == null) {
            return false;
        }
        return other.getIntegrationResponses() == null || other.getIntegrationResponses().equals(this.getIntegrationResponses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getHttpMethod() == null ? 0 : this.getHttpMethod().hashCode());
        hashCode = 31 * hashCode + (this.getUri() == null ? 0 : this.getUri().hashCode());
        hashCode = 31 * hashCode + (this.getCredentials() == null ? 0 : this.getCredentials().hashCode());
        hashCode = 31 * hashCode + (this.getRequestParameters() == null ? 0 : this.getRequestParameters().hashCode());
        hashCode = 31 * hashCode + (this.getRequestTemplates() == null ? 0 : this.getRequestTemplates().hashCode());
        hashCode = 31 * hashCode + (this.getPassthroughBehavior() == null ? 0 : this.getPassthroughBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNamespace() == null ? 0 : this.getCacheNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getCacheKeyParameters() == null ? 0 : this.getCacheKeyParameters().hashCode());
        hashCode = 31 * hashCode + (this.getIntegrationResponses() == null ? 0 : this.getIntegrationResponses().hashCode());
        return hashCode;
    }

    public UpdateIntegrationResult clone() {
        try {
            return (UpdateIntegrationResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

