/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetUsagePlanKeysRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetUsagePlanKeysRequestMarshaller
implements Marshaller<Request<GetUsagePlanKeysRequest>, GetUsagePlanKeysRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetUsagePlanKeysRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetUsagePlanKeysRequest> marshall(GetUsagePlanKeysRequest getUsagePlanKeysRequest) {
        if (getUsagePlanKeysRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getUsagePlanKeysRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/usageplans/{usageplanId}/keys";
        uriResourcePath = uriResourcePath.replace("{usageplanId}", getUsagePlanKeysRequest.getUsagePlanId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getUsagePlanKeysRequest.getUsagePlanId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        if (getUsagePlanKeysRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString((String)getUsagePlanKeysRequest.getPosition()));
        }
        if (getUsagePlanKeysRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger((Integer)getUsagePlanKeysRequest.getLimit()));
        }
        if (getUsagePlanKeysRequest.getNameQuery() != null) {
            request.addParameter("name", StringUtils.fromString((String)getUsagePlanKeysRequest.getNameQuery()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

