/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.ApiKey;
import java.util.List;

public class ApiKeyJsonMarshaller {
    private static ApiKeyJsonMarshaller instance;

    public void marshall(ApiKey apiKey, StructuredJsonGenerator jsonGenerator) {
        if (apiKey == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> stageKeysList;
            jsonGenerator.writeStartObject();
            if (apiKey.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(apiKey.getId());
            }
            if (apiKey.getValue() != null) {
                jsonGenerator.writeFieldName("value").writeValue(apiKey.getValue());
            }
            if (apiKey.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(apiKey.getName());
            }
            if (apiKey.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(apiKey.getDescription());
            }
            if (apiKey.getEnabled() != null) {
                jsonGenerator.writeFieldName("enabled").writeValue(apiKey.getEnabled().booleanValue());
            }
            if (apiKey.getCreatedDate() != null) {
                jsonGenerator.writeFieldName("createdDate").writeValue(apiKey.getCreatedDate());
            }
            if (apiKey.getLastUpdatedDate() != null) {
                jsonGenerator.writeFieldName("lastUpdatedDate").writeValue(apiKey.getLastUpdatedDate());
            }
            if ((stageKeysList = apiKey.getStageKeys()) != null) {
                jsonGenerator.writeFieldName("stageKeys");
                jsonGenerator.writeStartArray();
                for (String stageKeysListValue : stageKeysList) {
                    if (stageKeysListValue == null) continue;
                    jsonGenerator.writeValue(stageKeysListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ApiKeyJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ApiKeyJsonMarshaller();
        }
        return instance;
    }
}

