/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetDocumentationPartRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetDocumentationPartRequestMarshaller
implements Marshaller<Request<GetDocumentationPartRequest>, GetDocumentationPartRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetDocumentationPartRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetDocumentationPartRequest> marshall(GetDocumentationPartRequest getDocumentationPartRequest) {
        if (getDocumentationPartRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getDocumentationPartRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/documentation/parts/{part_id}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getDocumentationPartRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getDocumentationPartRequest.getRestApiId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{part_id}", getDocumentationPartRequest.getDocumentationPartId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getDocumentationPartRequest.getDocumentationPartId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

