/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.PatchOperation;
import com.amazonaws.services.apigateway.model.UpdateDocumentationVersionRequest;
import com.amazonaws.services.apigateway.model.transform.PatchOperationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class UpdateDocumentationVersionRequestMarshaller
implements Marshaller<Request<UpdateDocumentationVersionRequest>, UpdateDocumentationVersionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateDocumentationVersionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateDocumentationVersionRequest> marshall(UpdateDocumentationVersionRequest updateDocumentationVersionRequest) {
        if (updateDocumentationVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateDocumentationVersionRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/restapis/{restapi_id}/documentation/versions/{doc_version}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", updateDocumentationVersionRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)updateDocumentationVersionRequest.getRestApiId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{doc_version}", updateDocumentationVersionRequest.getDocumentationVersion() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)updateDocumentationVersionRequest.getDocumentationVersion()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<PatchOperation> patchOperationsList = updateDocumentationVersionRequest.getPatchOperations();
            if (patchOperationsList != null) {
                jsonGenerator.writeFieldName("patchOperations");
                jsonGenerator.writeStartArray();
                for (PatchOperation patchOperationsListValue : patchOperationsList) {
                    if (patchOperationsListValue == null) continue;
                    PatchOperationJsonMarshaller.getInstance().marshall(patchOperationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

