/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetMethodResponseRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetMethodResponseRequestMarshaller
implements Marshaller<Request<GetMethodResponseRequest>, GetMethodResponseRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetMethodResponseRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetMethodResponseRequest> marshall(GetMethodResponseRequest getMethodResponseRequest) {
        if (getMethodResponseRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getMethodResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getMethodResponseRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getMethodResponseRequest.getRestApiId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{resource_id}", getMethodResponseRequest.getResourceId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getMethodResponseRequest.getResourceId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{http_method}", getMethodResponseRequest.getHttpMethod() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getMethodResponseRequest.getHttpMethod()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{status_code}", getMethodResponseRequest.getStatusCode() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getMethodResponseRequest.getStatusCode()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

